/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.dm.repository.specification;

import com.finconsgroup.itserr.marketplace.metadata.dm.dto.MetadataStatus;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.MetadataFieldEntity;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.enumerated.MetadataCategoryEnum;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public final class MetadataFieldSpecifications {
    private MetadataFieldSpecifications() {
        throw new UnsupportedOperationException("Cannot be instantiated");
    }

    @NonNull
    public static Specification<MetadataFieldEntity> fetchMetadata() {
        return (Specification & Serializable)(root, query, cb) -> {
            if (query == null) {
                return cb.conjunction();
            }
            if (query.getResultType() != Long.class && query.getResultType() != Long.TYPE) {
                root.fetch("metadata", JoinType.INNER);
                query.distinct(true);
            }
            return cb.conjunction();
        };
    }

    @NonNull
    public static Specification<MetadataFieldEntity> metadataHasCategory(@Nullable MetadataCategoryEnum category) {
        return (Specification & Serializable)(root, query, cb) -> category == null ? cb.conjunction() : cb.equal((Expression)root.join("metadata").get("category"), (Object)category);
    }

    @NonNull
    public static Specification<MetadataFieldEntity> metadataExcludeCategory(@NonNull MetadataCategoryEnum category) {
        return (Specification & Serializable)(root, query, cb) -> cb.notEqual((Expression)root.join("metadata").get("category"), (Object)category);
    }

    @NonNull
    public static Specification<MetadataFieldEntity> metadataHasStatusIn(@Nullable Set<MetadataStatus> statuses) {
        return (Specification & Serializable)(root, query, cb) -> statuses == null || statuses.isEmpty() ? cb.conjunction() : root.join("metadata").get("status").in((Collection)statuses);
    }

    @NonNull
    public static Specification<MetadataFieldEntity> metadataHasCreatorId(@Nullable UUID creatorId) {
        return (Specification & Serializable)(root, query, cb) -> creatorId == null ? cb.conjunction() : cb.equal((Expression)root.join("metadata").get("creatorId"), (Object)creatorId);
    }

    @NonNull
    public static Specification<MetadataFieldEntity> nameContainsIgnoreCase(@Nullable String namePart) {
        return (Specification & Serializable)(root, query, cb) -> {
            if (namePart == null || namePart.isEmpty()) {
                return null;
            }
            return cb.like(cb.lower((Expression)root.get("name")), "%" + namePart.toLowerCase() + "%");
        };
    }
}

