/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.metadata.dm.api.MetadataModerationApi;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.InputModerationStatusDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.ModerationStatus;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.service.MetadataModerationService;
import java.util.UUID;
import lombok.Generated;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MetadataModerationController
implements MetadataModerationApi {
    private final MetadataModerationService metadataModerationService;

    public ResponseEntity<OutputPageDto<OutputMetadataDto>> getMetadataListForModeration(ModerationStatus status, String searchText, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[]{sort});
        return ResponseEntity.ok((Object)this.metadataModerationService.getMetadataListForModeration(status, searchText, JwtTokenHolder.getUserIdOrThrow(), (Pageable)pageable));
    }

    public ResponseEntity<OutputMetadataDto> getMetadataForModeration(UUID metadataId) {
        OutputMetadataDto result = this.metadataModerationService.getMetadataForModeration(metadataId);
        return ResponseEntity.ok((Object)result);
    }

    public ResponseEntity<OutputMetadataDto> setModerationStatus(UUID metadataId, InputModerationStatusDto inputModerationStatusDto) {
        return ResponseEntity.ok((Object)this.metadataModerationService.setModerationStatus(metadataId, inputModerationStatusDto, JwtTokenHolder.getUserIdOrThrow()));
    }

    @Generated
    public MetadataModerationController(MetadataModerationService metadataModerationService) {
        this.metadataModerationService = metadataModerationService;
    }
}

