package com.finconsgroup.itserr.marketplace.metadata.dm.mapper;

import com.finconsgroup.itserr.marketplace.metadata.dm.dto.InputCreateMetadataFieldDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.InputUpdateMetadataFieldDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataFieldDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataFieldExtDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataFieldType;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataMinimalDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.MetadataEntity;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.MetadataFieldEntity;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.enumerated.MetadataFieldTypeEnum;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2026-02-17T05:06:06+0000",
    comments = "version: 1.6.3, compiler: javac, environment: Java 21.0.9 (Eclipse Adoptium)"
)
@Component
public class MetadataFieldMapperImpl implements MetadataFieldMapper {

    @Override
    public MetadataFieldEntity metadataFieldSaveRequestDtoToMetadataFieldEntity(InputCreateMetadataFieldDto src) {
        if ( src == null ) {
            return null;
        }

        MetadataFieldEntity.MetadataFieldEntityBuilder<?, ?> metadataFieldEntity = MetadataFieldEntity.builder();

        metadataFieldEntity.name( src.getName() );
        metadataFieldEntity.description( src.getDescription() );
        metadataFieldEntity.type( outputMetadataFieldTypeToMetadataFieldTypeEnum( src.getType() ) );
        List<String> list = src.getVocabulary();
        if ( list != null ) {
            metadataFieldEntity.vocabulary( new ArrayList<String>( list ) );
        }
        metadataFieldEntity.validation( src.getValidation() );
        metadataFieldEntity.mandatory( src.isMandatory() );

        return metadataFieldEntity.build();
    }

    @Override
    public MetadataFieldEntity updateEntity(InputUpdateMetadataFieldDto dto) {
        if ( dto == null ) {
            return null;
        }

        MetadataFieldEntity.MetadataFieldEntityBuilder<?, ?> metadataFieldEntity = MetadataFieldEntity.builder();

        metadataFieldEntity.name( dto.getName() );
        metadataFieldEntity.description( dto.getDescription() );
        metadataFieldEntity.type( outputMetadataFieldTypeToMetadataFieldTypeEnum( dto.getType() ) );
        List<String> list = dto.getVocabulary();
        if ( list != null ) {
            metadataFieldEntity.vocabulary( new ArrayList<String>( list ) );
        }
        metadataFieldEntity.validation( dto.getValidation() );
        metadataFieldEntity.mandatory( dto.isMandatory() );

        return metadataFieldEntity.build();
    }

    @Override
    public OutputMetadataFieldDto metadataFieldEntityToMetadataFieldDto(MetadataFieldEntity src) {
        if ( src == null ) {
            return null;
        }

        OutputMetadataFieldDto.OutputMetadataFieldDtoBuilder outputMetadataFieldDto = OutputMetadataFieldDto.builder();

        outputMetadataFieldDto.name( src.getName() );
        outputMetadataFieldDto.description( src.getDescription() );
        outputMetadataFieldDto.type( metadataFieldTypeEnumToOutputMetadataFieldType( src.getType() ) );
        List<String> list = src.getVocabulary();
        if ( list != null ) {
            outputMetadataFieldDto.vocabulary( new ArrayList<String>( list ) );
        }
        outputMetadataFieldDto.validation( src.getValidation() );
        outputMetadataFieldDto.mandatory( src.isMandatory() );

        return outputMetadataFieldDto.build();
    }

    @Override
    public OutputMetadataFieldExtDto metadataFieldEntityToMetadataFieldExtDto(MetadataFieldEntity src) {
        if ( src == null ) {
            return null;
        }

        OutputMetadataFieldExtDto.OutputMetadataFieldExtDtoBuilder outputMetadataFieldExtDto = OutputMetadataFieldExtDto.builder();

        outputMetadataFieldExtDto.field( metadataFieldEntityToMetadataFieldDto( src ) );
        outputMetadataFieldExtDto.metadata( metadataEntityToOutputMetadataMinimalDto( src.getMetadata() ) );

        return outputMetadataFieldExtDto.build();
    }

    protected MetadataFieldTypeEnum outputMetadataFieldTypeToMetadataFieldTypeEnum(OutputMetadataFieldType outputMetadataFieldType) {
        if ( outputMetadataFieldType == null ) {
            return null;
        }

        MetadataFieldTypeEnum metadataFieldTypeEnum;

        switch ( outputMetadataFieldType ) {
            case STRING: metadataFieldTypeEnum = MetadataFieldTypeEnum.STRING;
            break;
            case TIME: metadataFieldTypeEnum = MetadataFieldTypeEnum.TIME;
            break;
            case TIME_INTERVAL: metadataFieldTypeEnum = MetadataFieldTypeEnum.TIME_INTERVAL;
            break;
            case TIMES_LISTOF: metadataFieldTypeEnum = MetadataFieldTypeEnum.TIMES_LISTOF;
            break;
            case TEXT: metadataFieldTypeEnum = MetadataFieldTypeEnum.TEXT;
            break;
            case BOOLEAN: metadataFieldTypeEnum = MetadataFieldTypeEnum.BOOLEAN;
            break;
            case NUMBER: metadataFieldTypeEnum = MetadataFieldTypeEnum.NUMBER;
            break;
            case GEO_JSON: metadataFieldTypeEnum = MetadataFieldTypeEnum.GEO_JSON;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + outputMetadataFieldType );
        }

        return metadataFieldTypeEnum;
    }

    protected OutputMetadataFieldType metadataFieldTypeEnumToOutputMetadataFieldType(MetadataFieldTypeEnum metadataFieldTypeEnum) {
        if ( metadataFieldTypeEnum == null ) {
            return null;
        }

        OutputMetadataFieldType outputMetadataFieldType;

        switch ( metadataFieldTypeEnum ) {
            case STRING: outputMetadataFieldType = OutputMetadataFieldType.STRING;
            break;
            case TIME: outputMetadataFieldType = OutputMetadataFieldType.TIME;
            break;
            case TIME_INTERVAL: outputMetadataFieldType = OutputMetadataFieldType.TIME_INTERVAL;
            break;
            case TIMES_LISTOF: outputMetadataFieldType = OutputMetadataFieldType.TIMES_LISTOF;
            break;
            case TEXT: outputMetadataFieldType = OutputMetadataFieldType.TEXT;
            break;
            case BOOLEAN: outputMetadataFieldType = OutputMetadataFieldType.BOOLEAN;
            break;
            case NUMBER: outputMetadataFieldType = OutputMetadataFieldType.NUMBER;
            break;
            case GEO_JSON: outputMetadataFieldType = OutputMetadataFieldType.GEO_JSON;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + metadataFieldTypeEnum );
        }

        return outputMetadataFieldType;
    }

    protected OutputMetadataMinimalDto metadataEntityToOutputMetadataMinimalDto(MetadataEntity metadataEntity) {
        if ( metadataEntity == null ) {
            return null;
        }

        OutputMetadataMinimalDto.OutputMetadataMinimalDtoBuilder outputMetadataMinimalDto = OutputMetadataMinimalDto.builder();

        outputMetadataMinimalDto.id( metadataEntity.getId() );
        outputMetadataMinimalDto.name( metadataEntity.getName() );
        outputMetadataMinimalDto.description( metadataEntity.getDescription() );
        outputMetadataMinimalDto.category( metadataEntity.getCategory() );
        outputMetadataMinimalDto.creatorId( metadataEntity.getCreatorId() );

        return outputMetadataMinimalDto.build();
    }
}
