package com.finconsgroup.itserr.marketplace.metadata.dm.exception;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;
import lombok.Getter;
import org.springframework.lang.NonNull;

/**
 * A business exception indicating that the operation cannot be completed because another metadata entry with the same name already exists.
 */
@Getter
public class MetadataExistsException extends WP2BusinessException {

    /**
     * Metadata name.
     */
    // TODO to not forget during i18n
    private final String name;

    /**
     * Constructor.
     * @param name Metadata name.
     */
    public MetadataExistsException(@NonNull final String name) {
        super("Another metadata exists with name: " + name);
        this.name = name;
    }

}
