/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.dm.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.metadata.dm.authorization.HasRoles;
import com.finconsgroup.itserr.marketplace.metadata.dm.authorization.RequireMetadataOwnership;
import com.finconsgroup.itserr.marketplace.metadata.dm.authorization.RequireMetadataStatus;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.InputCreateMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.InputInternalFindMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.InputUpdateMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.MetadataStatus;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataFieldDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataFieldExtDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataPreviewDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.ArchivedMetadataEntity;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.MetadataEntity;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.enumerated.MetadataCategoryEnum;
import com.finconsgroup.itserr.marketplace.metadata.dm.exception.MetadataExistsException;
import com.finconsgroup.itserr.marketplace.metadata.dm.exception.MetadataNotFoundException;
import com.finconsgroup.itserr.marketplace.metadata.dm.mapper.ArchivedMetadataMapper;
import com.finconsgroup.itserr.marketplace.metadata.dm.mapper.MetadataFieldMapper;
import com.finconsgroup.itserr.marketplace.metadata.dm.mapper.MetadataMapper;
import com.finconsgroup.itserr.marketplace.metadata.dm.repository.ArchivedMetadataRepository;
import com.finconsgroup.itserr.marketplace.metadata.dm.repository.MetadataFieldRepository;
import com.finconsgroup.itserr.marketplace.metadata.dm.repository.MetadataRepository;
import com.finconsgroup.itserr.marketplace.metadata.dm.repository.specification.MetadataFieldSpecifications;
import com.finconsgroup.itserr.marketplace.metadata.dm.repository.specification.MetadataSpecifications;
import com.finconsgroup.itserr.marketplace.metadata.dm.service.MetadataService;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultMetadataService
implements MetadataService {
    private final MetadataRepository metadataRepository;
    private final MetadataFieldRepository metadataFieldRepository;
    private final ArchivedMetadataRepository archivedMetadataRepository;
    private final MetadataMapper metadataMapper;
    private final MetadataFieldMapper metadataFieldMapper;
    private final ArchivedMetadataMapper archivedMetadataMapper;

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Page<OutputMetadataPreviewDto> findAll(String name, MetadataCategoryEnum category, UUID userId, @NonNull Pageable pageable) {
        MetadataCategoryEnum metadataCategoryEnum = category;
        Specification statusSpec = MetadataSpecifications.hasStatusIn(Set.of(MetadataStatus.APPROVED));
        Specification visibilitySpec = userId != null && (metadataCategoryEnum == null || metadataCategoryEnum.equals((Object)MetadataCategoryEnum.PERSONAL)) ? MetadataSpecifications.excludeCategory((MetadataCategoryEnum)MetadataCategoryEnum.PERSONAL).or(MetadataSpecifications.hasCategory((MetadataCategoryEnum)MetadataCategoryEnum.PERSONAL).and(MetadataSpecifications.hasCreatorId((UUID)userId))) : MetadataSpecifications.excludeCategory((MetadataCategoryEnum)MetadataCategoryEnum.PERSONAL);
        visibilitySpec = visibilitySpec.and(MetadataSpecifications.hasCategory((MetadataCategoryEnum)metadataCategoryEnum));
        if (name != null && !name.isEmpty()) {
            visibilitySpec = visibilitySpec.and(MetadataSpecifications.nameContainsIgnoreCase((String)name));
        }
        return this.metadataRepository.findAll(statusSpec.and(visibilitySpec), pageable).map(arg_0 -> ((MetadataMapper)this.metadataMapper).metadataEntityToMetadataPreviewDto(arg_0));
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Page<OutputMetadataFieldDto> findAllFieldsById(UUID metadataId, @NonNull Pageable pageable) {
        return this.metadataFieldRepository.findAllByMetadataId(metadataId, pageable).map(arg_0 -> ((MetadataFieldMapper)this.metadataFieldMapper).metadataFieldEntityToMetadataFieldDto(arg_0));
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Page<OutputMetadataFieldExtDto> findAllFields(MetadataCategoryEnum category, String name, Pageable pageable) {
        Pageable nonNullPageable = Objects.requireNonNull(pageable, "pageable");
        Optional userId = JwtTokenHolder.getUserId();
        MetadataCategoryEnum metadataCategoryEnum = category;
        Specification statusSpec = MetadataFieldSpecifications.metadataHasStatusIn(Set.of(MetadataStatus.APPROVED));
        Specification visibilitySpec = userId.isPresent() && (metadataCategoryEnum == null || metadataCategoryEnum.equals((Object)MetadataCategoryEnum.PERSONAL)) ? MetadataFieldSpecifications.metadataExcludeCategory((MetadataCategoryEnum)MetadataCategoryEnum.PERSONAL).or(MetadataFieldSpecifications.metadataHasCategory((MetadataCategoryEnum)MetadataCategoryEnum.PERSONAL).and(MetadataFieldSpecifications.metadataHasCreatorId((UUID)((UUID)userId.get())))) : MetadataFieldSpecifications.metadataExcludeCategory((MetadataCategoryEnum)MetadataCategoryEnum.PERSONAL);
        Specification categorySpec = MetadataFieldSpecifications.metadataHasCategory((MetadataCategoryEnum)metadataCategoryEnum);
        if (name != null && !name.isEmpty()) {
            categorySpec = categorySpec.and(MetadataFieldSpecifications.nameContainsIgnoreCase((String)name));
        }
        Specification fetchSpec = MetadataFieldSpecifications.fetchMetadata();
        return this.metadataFieldRepository.findAll(fetchSpec.and(statusSpec).and(visibilitySpec).and(categorySpec), nonNullPageable).map(arg_0 -> ((MetadataFieldMapper)this.metadataFieldMapper).metadataFieldEntityToMetadataFieldExtDto(arg_0));
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public OutputMetadataDto findById(@NonNull UUID metadataId) {
        return this.metadataRepository.findById(metadataId).map(arg_0 -> ((MetadataMapper)this.metadataMapper).metadataEntityToMetadataDto(arg_0)).orElseThrow(() -> new MetadataNotFoundException(metadataId));
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    @HasRoles(value={"Member"})
    public OutputMetadataDto create(@NonNull InputCreateMetadataDto request, @NonNull UUID userId) {
        String name = StringUtils.trim((String)request.getName());
        if (this.metadataRepository.countByNameIgnoreCase(name) > 0) {
            throw new MetadataExistsException(name);
        }
        MetadataEntity metadata = this.metadataMapper.metadataSaveRequestDtoToMetadataEntity(request, userId);
        metadata.setStatus(MetadataStatus.DRAFT);
        metadata.setUpdatedBy(userId);
        MetadataEntity savedMetadata = (MetadataEntity)this.metadataRepository.saveAndFlush((Object)metadata);
        return this.metadataMapper.metadataEntityToMetadataDto(savedMetadata);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    @HasRoles(value={"Member"})
    @RequireMetadataOwnership
    @RequireMetadataStatus(allowed={MetadataStatus.DRAFT, MetadataStatus.REJECTED})
    public OutputMetadataDto update(@NonNull UUID metadataId, @NonNull InputUpdateMetadataDto inputUpdateMetadataDto, @NonNull UUID userId) {
        String updatedName;
        MetadataEntity metadataEntity = (MetadataEntity)this.metadataRepository.findById(metadataId).orElseThrow(() -> new WP2ResourceNotFoundException(String.format("Metadata not found: %s", metadataId)));
        String currentName = StringUtils.trimToNull((String)metadataEntity.getName());
        if (!StringUtils.equalsIgnoreCase((CharSequence)currentName, (CharSequence)(updatedName = StringUtils.trimToNull((String)inputUpdateMetadataDto.getName()))) && this.metadataRepository.countByNameIgnoreCase(updatedName) > 0) {
            throw new MetadataExistsException(updatedName);
        }
        this.metadataMapper.updateEntity(inputUpdateMetadataDto, metadataEntity);
        metadataEntity.setStatus(MetadataStatus.DRAFT);
        metadataEntity.setUpdatedBy(userId);
        metadataEntity = (MetadataEntity)this.metadataRepository.saveAndFlush((Object)metadataEntity);
        return this.metadataMapper.metadataEntityToMetadataDto(metadataEntity);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, noRollbackFor={Exception.class}, readOnly=true)
    public List<OutputMetadataDto> find(@Nullable InputInternalFindMetadataDto request) {
        List foundMetadata = request == null ? this.metadataRepository.findAll() : this.metadataRepository.findAll(MetadataSpecifications.ids((Collection)request.getId()));
        return foundMetadata.stream().map(arg_0 -> ((MetadataMapper)this.metadataMapper).metadataEntityToMetadataDto(arg_0)).toList();
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    @HasRoles(value={"Member"})
    @RequireMetadataOwnership
    public OutputMetadataDto deleteById(@NonNull UUID metadataId) {
        MetadataEntity metadataEntity = (MetadataEntity)this.metadataRepository.findById(metadataId).orElseThrow(() -> new MetadataNotFoundException(metadataId));
        ArchivedMetadataEntity archivedMetadataEntity = this.archivedMetadataMapper.metadataEntityToArchivedMetadataEntity(metadataEntity);
        this.archivedMetadataRepository.save((Object)archivedMetadataEntity);
        this.metadataRepository.delete((Object)metadataEntity);
        return this.metadataMapper.metadataEntityToMetadataDto(metadataEntity);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    @HasRoles(value={"Member"})
    @RequireMetadataOwnership
    @RequireMetadataStatus(allowed={MetadataStatus.DRAFT})
    public OutputMetadataDto requestModeration(UUID metadataId, UUID userId) {
        MetadataEntity metadataEntity = (MetadataEntity)this.metadataRepository.findById(metadataId).orElseThrow(() -> new WP2ResourceNotFoundException(String.format("Metadata not found: %s", metadataId)));
        metadataEntity.setStatus(MetadataStatus.PENDING);
        metadataEntity.setModerationMessage(null);
        metadataEntity.setUpdatedBy(userId);
        metadataEntity = (MetadataEntity)this.metadataRepository.saveAndFlush((Object)metadataEntity);
        return this.metadataMapper.metadataEntityToMetadataDto(metadataEntity);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, noRollbackFor={Exception.class}, readOnly=true)
    public OutputPageDto<OutputMetadataDto> findAllByCreatorId(MetadataStatus status, @NonNull UUID creatorId, @NonNull Pageable pageable) {
        Set<MetadataStatus> statusList = status != null ? Set.of(status) : Set.of(MetadataStatus.APPROVED, MetadataStatus.DRAFT, MetadataStatus.PENDING, MetadataStatus.REJECTED);
        Specification spec = MetadataSpecifications.hasStatusIn(statusList).and(MetadataSpecifications.hasCreatorId((UUID)creatorId));
        return OutputPageDto.fromPage((Page)this.metadataRepository.findAll(spec, pageable).map(arg_0 -> ((MetadataMapper)this.metadataMapper).metadataEntityToMetadataDto(arg_0)));
    }

    @Generated
    public DefaultMetadataService(MetadataRepository metadataRepository, MetadataFieldRepository metadataFieldRepository, ArchivedMetadataRepository archivedMetadataRepository, MetadataMapper metadataMapper, MetadataFieldMapper metadataFieldMapper, ArchivedMetadataMapper archivedMetadataMapper) {
        this.metadataRepository = metadataRepository;
        this.metadataFieldRepository = metadataFieldRepository;
        this.archivedMetadataRepository = archivedMetadataRepository;
        this.metadataMapper = metadataMapper;
        this.metadataFieldMapper = metadataFieldMapper;
        this.archivedMetadataMapper = archivedMetadataMapper;
    }
}

