/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.metadata.dm.api.MetadataApi;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.InputCreateMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.InputUpdateMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.MetadataStatus;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataFieldDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataFieldExtDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataPreviewDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.enumerated.MetadataCategoryEnum;
import com.finconsgroup.itserr.marketplace.metadata.dm.service.MetadataService;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MetadataController
implements MetadataApi {
    private final MetadataService metadataService;

    public Page<OutputMetadataPreviewDto> findAll(String name, MetadataCategoryEnum category, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[]{sort});
        Optional userId = JwtTokenHolder.getUserId();
        return this.metadataService.findAll(name, category, (UUID)userId.orElse(null), (Pageable)pageable);
    }

    public OutputMetadataDto findById(UUID metadataId) {
        return this.metadataService.findById(metadataId);
    }

    public OutputMetadataDto create(InputCreateMetadataDto request) {
        return this.metadataService.create(request, JwtTokenHolder.getUserIdOrThrow());
    }

    public OutputMetadataDto update(UUID metadataId, InputUpdateMetadataDto inputUpdateItemDto) {
        return this.metadataService.update(metadataId, inputUpdateItemDto, JwtTokenHolder.getUserIdOrThrow());
    }

    public OutputMetadataDto deleteById(UUID metadataId) {
        JwtTokenHolder.getUserIdOrThrow();
        return this.metadataService.deleteById(metadataId);
    }

    public Page<OutputMetadataFieldExtDto> findAllFields(String name, MetadataCategoryEnum category, @PositiveOrZero int pageNumber, @Positive int pageSize, String sort, Sort.Direction direction) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[]{sort});
        return this.metadataService.findAllFields(category, name, (Pageable)pageable);
    }

    public Page<OutputMetadataFieldDto> findAllFieldsById(UUID metadataId, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[]{sort});
        return this.metadataService.findAllFieldsById(metadataId, (Pageable)pageable);
    }

    public ResponseEntity<OutputMetadataDto> requestModeration(UUID metadataId) {
        return ResponseEntity.ok((Object)this.metadataService.requestModeration(metadataId, JwtTokenHolder.getUserIdOrThrow()));
    }

    public ResponseEntity<OutputPageDto<OutputMetadataDto>> findAllByCreatorId(MetadataStatus status, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[]{sort});
        return ResponseEntity.ok((Object)this.metadataService.findAllByCreatorId(status, JwtTokenHolder.getUserIdOrThrow(), (Pageable)pageable));
    }

    @Generated
    public MetadataController(MetadataService metadataService) {
        this.metadataService = metadataService;
    }
}

