package com.finconsgroup.itserr.marketplace.metadata.dm.service;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.InputModerationStatusDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.ModerationStatus;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataDto;
import org.springframework.data.domain.Pageable;

import java.util.UUID;

/**
 * Service interface for metadata moderation operations.
 */
public interface MetadataModerationService {

    /**
     * Retrieves list of metadata for moderation.
     *
     * @param status     Filter by moderation status (PENDING or REJECTED). If null, returns both.
     * @param searchText the text to filter metadata by name and description
     * @param userId     The ID of the moderator setting the status
     * @param pageable   the pagination information
     * @return A paginated list of metadata for moderation
     */
    OutputPageDto<OutputMetadataDto> getMetadataListForModeration(ModerationStatus status, String searchText, UUID userId, Pageable pageable);

    /**
     * Retrieves a specific metadata for moderation.
     *
     * @param metadataId The unique identifier of the metadata
     * @return metadata
     */
    OutputMetadataDto getMetadataForModeration(UUID metadataId);

    /**
     * Sets the moderation status of a metadata.
     *
     * @param metadataId               The unique identifier of the metadata
     * @param inputModerationStatusDto The DTO containing the moderation status and optional message
     * @param userId                   The ID of the moderator setting the status
     * @return The moderation DTO, with the operation type and the complete metadata DTO
     */
    OutputMetadataDto setModerationStatus(UUID metadataId, InputModerationStatusDto inputModerationStatusDto, UUID userId);
}
