package com.finconsgroup.itserr.marketplace.metadata.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.metadata.dm.api.MetadataModerationApi;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.InputModerationStatusDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.ModerationStatus;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.service.MetadataModerationService;
import lombok.RequiredArgsConstructor;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

import java.util.UUID;

@RestController
@RequiredArgsConstructor
public class MetadataModerationController implements MetadataModerationApi {
    private final MetadataModerationService metadataModerationService;

    @Override
    public ResponseEntity<OutputPageDto<OutputMetadataDto>> getMetadataListForModeration(
            ModerationStatus status,
            String searchText,
            int pageNumber,
            int pageSize,
            String sort,
            Sort.Direction direction
    ) {
        Pageable pageable = PageRequest.of(pageNumber, pageSize, direction, sort);
        return ResponseEntity.ok(metadataModerationService.getMetadataListForModeration(status, searchText, JwtTokenHolder.getUserIdOrThrow(), pageable));
    }

    @Override
    public ResponseEntity<OutputMetadataDto> getMetadataForModeration(UUID metadataId) {
        OutputMetadataDto result = metadataModerationService.getMetadataForModeration(metadataId);
        return ResponseEntity.ok(result);
    }

    @Override
    public ResponseEntity<OutputMetadataDto> setModerationStatus(UUID metadataId, InputModerationStatusDto inputModerationStatusDto) {
        return ResponseEntity.ok(metadataModerationService.setModerationStatus(metadataId, inputModerationStatusDto, JwtTokenHolder.getUserIdOrThrow()));
    }
}
