package com.finconsgroup.itserr.marketplace.metadata.dm.utils;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.CodeSignature;

public class AOPUtils {

    /**
     * Extracts the actual parameter value from a method invocation based on its name and type.
     * Throws an exception if the parameter is not found, is null, or its type does not match the expected type.
     *
     * @param pjp the {@code ProceedingJoinPoint} representing the intercepted method call
     * @param paramName the name of the parameter to be retrieved
     * @param paramType the expected {@code Class} type of the parameter
     * @param <T> the type of the parameter to be extracted
     * @return the parameter value cast to the specified type
     * @throws IllegalArgumentException if the parameter is not found, is null, or is not of the expected type
     */
    public static <T> T extractActualParam(ProceedingJoinPoint pjp, String paramName, Class<T> paramType) {
        String[] argNames = ((CodeSignature) pjp.getSignature()).getParameterNames();
        Object[] args = pjp.getArgs();

        for (int i = 0; i < argNames.length; i++) {
            if (argNames[i].equals(paramName)) {
                Object arg = args[i];

                if (arg == null) {
                    throw new IllegalArgumentException("Parameter '" + paramName + "' cannot be null");
                }

                if (!paramType.isInstance(arg)) {
                    throw new IllegalArgumentException(
                            "Parameter '" + paramName + "' must be " + paramType.getSimpleName() +
                                    ", but was " + arg.getClass().getSimpleName()
                    );

                }

                return paramType.cast(arg);
            }
        }

        throw new IllegalArgumentException("Parameter '" + paramName + "' not found in method signature");
    }

}
