package com.finconsgroup.itserr.marketplace.metadata.dm.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.cache.support.NoOpCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.web.context.WebApplicationContext;

import java.util.List;

import static com.finconsgroup.itserr.marketplace.metadata.dm.constants.Caches.METADATA_CACHE;

@Configuration
@EnableCaching
public class CacheConfig {

    /**
     * Per-request cache manager
     * Each request gets its own cache instance
     */
    @Bean
    @ConditionalOnProperty(name = "metadata.dm.cache.enabled", havingValue = "true")
    @Scope(value = WebApplicationContext.SCOPE_REQUEST, proxyMode = ScopedProxyMode.TARGET_CLASS)
    @Primary
    public CacheManager requestScopedCacheManager() {
        CaffeineCacheManager cacheManager = new CaffeineCacheManager();

        // Configure Caffeine cache
        cacheManager.setCaffeine(Caffeine.newBuilder()
                .maximumSize(10)
        );

        // Define cache names
        cacheManager.setCacheNames(List.of(
                METADATA_CACHE
        ));

        return cacheManager;
    }

    /**
     * Provides a NoOpCacheManager as a fallback when caching is disabled,
     * e.g., during testing when there are no active http requests.
     * This cache manager performs no caching and serves as a no-operation implementation.
     *
     * @return an instance of NoOpCacheManager, which disables caching functionality.
     */
    @Bean
    @ConditionalOnProperty(name = "metadata.dm.cache.enabled", havingValue = "false")
    public CacheManager noOpCacheManager() {
        return new NoOpCacheManager();
    }
}
