/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.dm.api;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.exception.ErrorResponseDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.InputModerationStatusDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.ModerationStatus;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.UUID;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Tag(name="Metadata Moderation", description="Operations for moderators to review and approve/reject list of Metadata")
@SecurityRequirement(name="BearerAuth")
public interface MetadataModerationApi {
    @Operation(summary="Get list of metadata for moderation", description="Returns list of metadata for moderation. API for moderators. Can be filtered by status (pending or rejected). By default returns both pending and rejected list of metadata.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved list of metadata for moderation"), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))}), @ApiResponse(responseCode="403", description="Forbidden - not a moderator", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @GetMapping(path={"/metadata/moderation"}, produces={"application/json"})
    public ResponseEntity<OutputPageDto<OutputMetadataDto>> getMetadataListForModeration(@RequestParam(required=false) ModerationStatus var1, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var2, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var3, @RequestParam(name="sort", defaultValue="name", required=false) String var4, @RequestParam(name="direction", defaultValue="ASC", required=false) Sort.Direction var5);

    @Operation(summary="Get metadata for moderation", description="Returns the a metadata (any state except draft). Available to moderators.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved the metadata for moderation", content={@Content(schema=@Schema(implementation=OutputMetadataDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))}), @ApiResponse(responseCode="403", description="Forbidden - not a moderator", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))}), @ApiResponse(responseCode="404", description="Metadata not found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @GetMapping(path={"/metadata/{metadataId}/moderation"}, produces={"application/json"})
    public ResponseEntity<OutputMetadataDto> getMetadataForModeration(@PathVariable UUID var1);

    @Operation(summary="Set moderation status", description="Sets the moderation status (approved/rejected) for an metadata.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Moderation status successfully set", content={@Content(schema=@Schema(implementation=OutputMetadataDto.class))}), @ApiResponse(responseCode="400", description="Invalid input provided", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))}), @ApiResponse(responseCode="403", description="Forbidden - not a moderator", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))}), @ApiResponse(responseCode="404", description="Metadata not found", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponseDto.class))})})
    @PatchMapping(path={"/metadata/{metadataId}/moderation-status"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<OutputMetadataDto> setModerationStatus(@PathVariable UUID var1, @RequestBody @Valid @Parameter(description="Moderation status details", required=true) InputModerationStatusDto var2);
}

