package com.finconsgroup.itserr.marketplace.metadata.dm;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.info.Info;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.autoconfigure.metrics.cache.CacheMetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;

/**
 * Application main class.
 */
@SpringBootApplication(exclude = { CacheMetricsAutoConfiguration.class})
@OpenAPIDefinition(info = @Info(
        title = "Metadata DM API",
        description = "API definition of the Metadata DM Microservice",
        version = "1.0.0"
))
public class MetadataDmApplication {

    /**
     * Main.
     * @param args Arguments.
     */
    public static void main(String[] args) {
        SpringApplication.run(MetadataDmApplication.class, args);
    }

}
