create schema if not exists "wp2_metadata";

set schema 'wp2_metadata';

create table if not exists "metadata" (
  id uuid primary key,
  name varchar(50) not null unique,
  description varchar(255),
  standard boolean not null,
  version bigint
);

create table if not exists "metadata_field" (
  id uuid primary key,
  metadata_id uuid not null,
  name varchar(50) not null,
  description varchar(255),
  type varchar(20) not null,
  vocabulary text,
  validation varchar(255),
  mandatory boolean,
  foreign key (metadata_id) references "metadata"(id)
);

create table if not exists "archived_metadata" (
  id uuid primary key,
  name varchar(50) not null,
  description varchar(255),
  standard boolean not null
);

create table if not exists "archived_metadata_field" (
  id uuid primary key,
  metadata_id uuid,
  name varchar(50) not null,
  description varchar(255),
  type varchar(20) not null,
  vocabulary text,
  validation varchar(255),
  mandatory boolean,
  foreign key (metadata_id) references "archived_metadata"(id)
);

--comment: SCRUM-3068 add category column to metadata table
alter table "metadata" add column IF NOT EXISTS "category" varchar(50);

--comment: SCRUM-3068 add category creator_id to metadata table
alter table "metadata" add column IF NOT EXISTS "creator_id" UUID;

--comment: SCRUM-3068 drop column standard from metadata table
alter table "metadata" drop column IF EXISTS "standard";

--comment: SCRUM-3068 add category column to archived_metadata table
alter table "archived_metadata" add column IF NOT EXISTS "category" varchar(50);

--comment: SCRUM-3068 add creator_id to archived_metadata table
alter table "archived_metadata" add column IF NOT EXISTS "creator_id" UUID;

--comment: SCRUM-3068 drop column standard from archived_metadata table
alter table "archived_metadata" drop column IF EXISTS "standard";

--comment: SCRUM-3101 add status column to metadata table
alter table "metadata" add column IF NOT EXISTS "status" varchar(50);

--comment: SCRUM-3101 add moderation_message column to metadata table
alter table "metadata" add column IF NOT EXISTS "moderation_message" varchar(2000);

--comment: SCRUM-3101 add created_at column to metadata table
alter table "metadata" add column IF NOT EXISTS "created_at" timestamp with time zone not null;

--comment: SCRUM-3101 add updated_at column to metadata table
alter table "metadata" add column IF NOT EXISTS "updated_at" timestamp with time zone not null;

--comment: SCRUM-3101 add updated_by column to metadata table
alter table "metadata" add column IF NOT EXISTS "updated_by" UUID;

--comment: SCRUM-3101 add status column to archived_metadata table
alter table "archived_metadata" add column IF NOT EXISTS "status" varchar(50);

--comment: SCRUM-3101 add moderation_message column to archived_metadata table
alter table "archived_metadata" add column IF NOT EXISTS "moderation_message" varchar(2000);

--comment: SCRUM-3101 add created_at column to archived_metadata table
alter table "archived_metadata" add column IF NOT EXISTS "created_at" timestamp with time zone not null;

--comment: SCRUM-3101 add updated_at column to archived_metadata table
alter table "archived_metadata" add column IF NOT EXISTS "updated_at" timestamp with time zone not null;

--comment: SCRUM-3101 add updated_by column to archived_metadata table
alter table "archived_metadata" add column IF NOT EXISTS "updated_by" UUID;

--comment: SCRUM-3101 add updated_at column to archived_metadata table
alter table "archived_metadata" add column IF NOT EXISTS "version" bigint;

--comment: SCRUM-3101 add updated_at column to archived_metadata table
alter table "archived_metadata" add column IF NOT EXISTS "archived_at" timestamp with time zone not null;