package com.finconsgroup.itserr.marketplace.metadata.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * Metadata field DTO.
 */
@Schema(
        name = "MetadataField",
        description = "A field of a metadata"
)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputMetadataFieldDto {

    @Schema(description = "Field name")
    private String name;

    @Schema(description = "Description")
    private String description;

    @Schema(description = "Type of the field expected value")
    private OutputMetadataFieldType type;

    @Schema(description = """
                List of terms that are allowed as values, or null/empty for any available.
                This should be alternative to 'validation'.
            """)
    private List<String> vocabulary;

    @Schema(description = """
             A regex that the value should comply with.
             This should be alternative to 'vocabulary'.
            """)
    private String validation;

    @Schema(
            description = "true if the metadata value is mandatory, false otherwise",
            defaultValue = "false")
    private boolean mandatory;

}
