package com.finconsgroup.itserr.marketplace.metadata.dm.authorization;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2AuthorizationException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.MetadataEntity;
import com.finconsgroup.itserr.marketplace.metadata.dm.repository.MetadataRepository;
import com.finconsgroup.itserr.marketplace.metadata.dm.utils.AOPUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.util.UUID;

@Aspect
@Component
@Order(1)
@Slf4j
@RequiredArgsConstructor
public class OwnershipAspect {
    private final MetadataRepository metadataRepository;

    @Around("@annotation(requireMetadataOwnership)")
    public Object checkOwnership(ProceedingJoinPoint pjp, RequireMetadataOwnership requireMetadataOwnership) throws Throwable {
        UUID metadataId = AOPUtils.extractActualParam(pjp, requireMetadataOwnership.metadataIdParam(), UUID.class);

        MetadataEntity metadata = metadataRepository.findById(metadataId).orElseThrow(() ->
                new WP2ResourceNotFoundException(String.format("Metadata not found: %s", metadataId)));

        if (!metadata.getCreatorId().equals(JwtTokenHolder.getUserIdOrThrow())) {
            throw new WP2AuthorizationException(String.format("User %s does not own the Metadata", JwtTokenHolder.getUserIdOrThrow()));
        }

        return pjp.proceed();
    }

}
