package com.finconsgroup.itserr.marketplace.metadata.dm.entity;

import com.finconsgroup.itserr.marketplace.metadata.dm.entity.converter.StringListConverter;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.enumerated.MetadataFieldTypeEnum;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.SuperBuilder;

import java.util.List;

/**
 * This entity represents one of the fields of a {@link MetadataEntity}.
 */
@Entity
@Table(name = "metadata_field")
@SuperBuilder
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(exclude = {"metadata"})
@NoArgsConstructor
public class MetadataFieldEntity extends AbstractUUIDEntity {

    /** Name field length. */
    public static final int NAME_LENGTH = 50;
    /** Type field length. */
    public static final int TYPE_LENGTH = 20;
    /** Description field length. */
    public static final int DESCRIPTION_LENGTH = 2000;

    /**
     * The metadata to which this field belongs.
     */
    @ManyToOne
    @JoinColumn(name = "metadata_id", nullable = false)
    private MetadataEntity metadata;

    /**
     * Field name.
     */
    @Column(name = "name", nullable = false, length = NAME_LENGTH)
    private String name;

    /**
     * Description.
     */
    @Column(name = "description", length = DESCRIPTION_LENGTH)
    private String description;

    /**
     * Type of the field expected value.
     */
    @Enumerated(EnumType.STRING)
    @Column(name = "type", nullable = false, length = TYPE_LENGTH)
    private MetadataFieldTypeEnum type;

    /**
     * <p>List of terms that are allowed as values, or null/empty for any available.</p>
     * <p>This should be alternative to {@link #validation}</p>
     */
    @Lob
    @Convert(converter = StringListConverter.class)
    @Column(name = "vocabulary")
    private List<String> vocabulary;

    /**
     * <p>A regex that the value should comply with.</p>
     * <p>This should be alternative to {@link #vocabulary}</p>
     */
    @Column(name = "validation")
    private String validation;

    /**
     * true if the metadata value is mandatory, false otherwise.
     */
    @Column(name = "mandatory")
    private boolean mandatory;

}
