/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.userprofile.UserProfileBsClient;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.userprofile.UserProfileDmClient;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.userprofile.dto.InputFindUserProfilesByIdsDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.userprofile.dto.UserProfileBsOutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.mapper.UserProfileMapper;
import com.finconsgroup.itserr.marketplace.metadata.bs.service.UserProfileDetailProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
public class DefaultUserProfileDetailsProvider
implements UserProfileDetailProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultUserProfileDetailsProvider.class);
    @Value(value="${metadata.bs.role-moderator}")
    private String roleModerator;
    private final UserProfileDmClient userProfileDmClient;
    private final UserProfileBsClient userProfileBsClient;
    private final UserProfileMapper userProfileMapper;

    public Map<UUID, OutputUserProfileDto> getUserDetailById(List<UUID> userProfileIds) {
        if (userProfileIds.isEmpty()) {
            return Map.of();
        }
        HashMap<UUID, OutputUserProfileDto> outputUserProfileDtoMap = new HashMap<UUID, OutputUserProfileDto>();
        try {
            InputFindUserProfilesByIdsDto inputFindUserProfilesByIdsDto = InputFindUserProfilesByIdsDto.builder().ids(new ArrayList<UUID>(userProfileIds)).build();
            OutputPageDto userOutputProfileDmPageDto = this.userProfileDmClient.findAllByIds(inputFindUserProfilesByIdsDto, 0, userProfileIds.size(), "id", SortDirection.ASC);
            userOutputProfileDmPageDto.getContent().forEach(outputUserProfileDmDto -> outputUserProfileDtoMap.put(outputUserProfileDmDto.getId(), this.userProfileMapper.userProfileDtoToCreatorDto(outputUserProfileDmDto)));
        }
        catch (Exception e) {
            log.error("Error loading user profiles", (Throwable)e);
        }
        return outputUserProfileDtoMap;
    }

    @NonNull
    public List<UUID> getModeratorProfilesIds() {
        try {
            return this.userProfileBsClient.getUserProfilesByRole(this.roleModerator).stream().map(UserProfileBsOutputUserProfileDto::getId).toList();
        }
        catch (Exception e) {
            log.error("Error loading user profiles by role", (Throwable)e);
            return List.of();
        }
    }

    @Generated
    public DefaultUserProfileDetailsProvider(UserProfileDmClient userProfileDmClient, UserProfileBsClient userProfileBsClient, UserProfileMapper userProfileMapper) {
        this.userProfileDmClient = userProfileDmClient;
        this.userProfileBsClient = userProfileBsClient;
        this.userProfileMapper = userProfileMapper;
    }
}

