/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.bs.controller;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.metadata.bs.api.DiagnosticsApi;
import com.finconsgroup.itserr.marketplace.metadata.bs.bean.MetadataEvent;
import com.finconsgroup.itserr.marketplace.metadata.bs.bean.MetadataModerationRequestedEvent;
import com.finconsgroup.itserr.marketplace.metadata.bs.bean.MetadataStatusEvent;
import com.finconsgroup.itserr.marketplace.metadata.bs.config.MetadataBsConfigurationProperties;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.MetadataStatus;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.enums.EventType;
import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
public class DiagnosticsController
implements DiagnosticsApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiagnosticsController.class);
    private final MetadataBsConfigurationProperties metadataBsConfigurationProperties;
    private final ApplicationEventPublisher applicationEventPublisher;
    static Map<String, OutputMetadataDto> stringOutputMetadataDtoHashMap = new HashMap();
    @Value(value="${log.log4j2-rolling-file-name}")
    private String log4j2RollingFileName;

    public ResponseEntity<Resource> downloadLogs() {
        log.debug("call to DiagnosticsController - downloadLogs");
        Path filePath = Paths.get(this.getLogFilePathFromLog4j2(), new String[0]);
        log.debug("Trying to retrieve log file from: {}", (Object)filePath);
        File logFile = filePath.toFile();
        if (!logFile.exists() || !logFile.isFile()) {
            throw new WP2ResourceNotFoundException("Log file not found: %s".formatted(logFile.getAbsolutePath()));
        }
        FileSystemResource resource = new FileSystemResource(logFile);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{DiagnosticsController.getContentDispositionHeaderValue((String)logFile.getName())})).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)resource);
    }

    public String getLogFilePathFromLog4j2() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        RollingFileAppender appender = (RollingFileAppender)context.getConfiguration().getAppender(this.log4j2RollingFileName);
        return appender.getFileName();
    }

    private static String getContentDispositionHeaderValue(String fileName) {
        return "attachment; filename=\"%s\"".formatted(fileName);
    }

    public ResponseEntity<String> publishMessage(EventType eventType, String name) {
        OutputMetadataDto outputMetadataDto;
        if (!this.metadataBsConfigurationProperties.getDiagnostics().isPublishMessageEnabled()) {
            log.warn("Attempt to access disabled diagnostics endpoint");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)"This endpoint is disabled in the current environment");
        }
        log.debug("call to DiagnosticsController - publishMessage, name: %s".formatted(name));
        EventType eventType2 = eventType;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"CREATED", "UPDATED", "APPROVED", "REJECTED", "MODERATION_REQUESTED", "DELETED"}, (EventType)eventType2, n)) {
            case 0: {
                outputMetadataDto = this.buildTestOutputMetadataDto(name, MetadataStatus.DRAFT);
                log.info("sending created message, outputMetadataDto: %s".formatted(outputMetadataDto));
                stringOutputMetadataDtoHashMap.put(outputMetadataDto.getName(), outputMetadataDto);
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new MetadataEvent(outputMetadataDto, EventType.CREATED));
                break;
            }
            case 1: {
                outputMetadataDto = this.buildTestOutputMetadataDto(name, MetadataStatus.DRAFT);
                log.info("sending updated message, outputMetadataDto: %s".formatted(outputMetadataDto));
                stringOutputMetadataDtoHashMap.put(outputMetadataDto.getName(), outputMetadataDto);
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new MetadataEvent(outputMetadataDto, EventType.UPDATED));
                break;
            }
            case 2: {
                outputMetadataDto = this.buildTestOutputMetadataDto(name, MetadataStatus.APPROVED);
                log.info("sending approved message, outputMetadataDto: %s".formatted(outputMetadataDto));
                stringOutputMetadataDtoHashMap.put(outputMetadataDto.getName(), outputMetadataDto);
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new MetadataStatusEvent(outputMetadataDto, EventType.APPROVED));
                break;
            }
            case 3: {
                outputMetadataDto = this.buildTestOutputMetadataDto(name, MetadataStatus.REJECTED);
                log.info("sending rejected message, outputMetadataDto: %s".formatted(outputMetadataDto));
                stringOutputMetadataDtoHashMap.put(outputMetadataDto.getName(), outputMetadataDto);
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new MetadataStatusEvent(outputMetadataDto, EventType.REJECTED));
                break;
            }
            case 4: {
                outputMetadataDto = this.buildTestOutputMetadataDto(name, MetadataStatus.PENDING);
                log.info("sending message for moderation, outputMetadataDto: %s".formatted(outputMetadataDto));
                stringOutputMetadataDtoHashMap.put(outputMetadataDto.getName(), outputMetadataDto);
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new MetadataModerationRequestedEvent(outputMetadataDto, EventType.MODERATION_REQUESTED));
                break;
            }
            case 5: {
                outputMetadataDto = this.buildTestOutputMetadataDto(name, MetadataStatus.DRAFT);
                if (outputMetadataDto == null) {
                    return ResponseEntity.badRequest().body((Object)"no test item created for name: %s".formatted(name));
                }
                log.info("sending deleted message, outputMetadataDto: %s".formatted(outputMetadataDto));
                stringOutputMetadataDtoHashMap.remove(outputMetadataDto.getName());
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new MetadataEvent(outputMetadataDto, EventType.DELETED));
                break;
            }
            default: {
                return ResponseEntity.badRequest().body((Object)("Event type must be one of: " + Arrays.toString(EventType.values())));
            }
        }
        return ResponseEntity.ok((Object)"message sent correctly, outputMetadataDto: %s".formatted(outputMetadataDto));
    }

    private OutputMetadataDto buildTestOutputMetadataDto(String name, MetadataStatus status) {
        return OutputMetadataDto.builder().id(UUID.randomUUID()).name(name).status(status).creator(OutputUserProfileDto.builder().id(UUID.randomUUID()).build()).build();
    }

    @Generated
    public DiagnosticsController(MetadataBsConfigurationProperties metadataBsConfigurationProperties, ApplicationEventPublisher applicationEventPublisher) {
        this.metadataBsConfigurationProperties = metadataBsConfigurationProperties;
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

