/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.InputCreateMetadataDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.InputUpdateMetadataDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.MetadataCategoryDmEnum;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.MetadataDmStatus;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.OutputMetadataDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.OutputMetadataFieldDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.OutputMetadataFieldExtDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.OutputMetadataPreviewDmDto;
import jakarta.validation.Valid;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public interface MetadataDmClient {
    @GetMapping(value={"/metadata"}, produces={"application/json"})
    public Page<OutputMetadataPreviewDmDto> findAll(@RequestParam(required=false) String var1, @RequestParam(required=false) MetadataCategoryDmEnum var2, @RequestParam(name="pageNumber", defaultValue="0", required=false) int var3, @RequestParam(name="pageSize", defaultValue="10", required=false) int var4, @RequestParam(name="sort", defaultValue="name", required=false) String var5, @RequestParam(name="direction", defaultValue="ASC", required=false) Sort.Direction var6);

    @GetMapping(value={"/metadata/{metadataId}"}, produces={"application/json"})
    public OutputMetadataDmDto findById(@PathVariable(value="metadataId") UUID var1);

    @PostMapping(path={"/metadata"}, consumes={"application/json"}, produces={"application/json"})
    public OutputMetadataDmDto create(@Valid @RequestBody InputCreateMetadataDmDto var1);

    @PutMapping(path={"/metadata/{metadataId}"}, produces={"application/json"}, consumes={"application/json"})
    public OutputMetadataDmDto update(@PathVariable UUID var1, @RequestBody @Valid InputUpdateMetadataDmDto var2);

    @DeleteMapping(path={"/metadata/{id}"}, produces={"application/json"})
    public OutputMetadataDmDto delete(@NonNull @PathVariable(value="id") UUID var1);

    @GetMapping(value={"/metadata/{metadataId}/fields"}, produces={"application/json"})
    public Page<OutputMetadataFieldDmDto> findAllFieldsById(@PathVariable(value="metadataId") UUID var1, @RequestParam(name="pageNumber", defaultValue="0", required=false) int var2, @RequestParam(name="pageSize", defaultValue="10", required=false) int var3, @RequestParam(name="sort", defaultValue="name", required=false) String var4, @RequestParam(name="direction", defaultValue="ASC", required=false) Sort.Direction var5);

    @GetMapping(value={"/metadata/fields"}, produces={"application/json"})
    public Page<OutputMetadataFieldExtDmDto> findAllFields(@RequestParam(required=false) String var1, @RequestParam(required=false) MetadataCategoryDmEnum var2, @RequestParam(name="pageNumber", defaultValue="0", required=false) int var3, @RequestParam(name="pageSize", defaultValue="10", required=false) int var4, @RequestParam(name="sort", defaultValue="name", required=false) String var5, @RequestParam(name="direction", defaultValue="ASC", required=false) Sort.Direction var6);

    @PostMapping(path={"/metadata/{metadataId}/moderation-request"}, produces={"application/json"})
    public OutputMetadataDmDto requestModeration(@PathVariable UUID var1);

    @GetMapping(value={"/metadata/mine"}, produces={"application/json"})
    public OutputPageDto<OutputMetadataDmDto> findAllByCreatorId(@RequestParam(required=false) MetadataDmStatus var1, @RequestParam(name="pageNumber", defaultValue="0", required=false) int var2, @RequestParam(name="pageSize", defaultValue="10", required=false) int var3, @RequestParam(name="sort", defaultValue="name", required=false) String var4, @RequestParam(name="direction", defaultValue="ASC", required=false) Sort.Direction var5);
}

