package com.finconsgroup.itserr.marketplace.metadata.bs.controller;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.api.MetadataModerationApi;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.InputModerationStatusDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.ModerationStatus;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.service.MetadataModerationService;
import lombok.RequiredArgsConstructor;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

import java.util.UUID;

@RestController
@RequiredArgsConstructor
public class MetadataModerationController implements MetadataModerationApi {
    private final MetadataModerationService metadataModerationService;

    @Override
    public ResponseEntity<OutputPageDto<OutputMetadataDto>> getMetadataListForModeration(
            ModerationStatus status,
            String searchText,
            int pageNumber,
            int pageSize,
            String sort,
            Sort.Direction direction
    ) {
        OutputPageDto<OutputMetadataDto> outputMetadataDto = metadataModerationService.getMetadataListForModeration(
                status, searchText, pageNumber, pageSize, sort, direction);
        return ResponseEntity.ok(outputMetadataDto);
    }

    @Override
    public ResponseEntity<OutputMetadataDto> getMetadataForModeration(UUID metadataId) {
        OutputMetadataDto result = metadataModerationService.getMetadataForModeration(metadataId);
        return ResponseEntity.ok(result);
    }

    @Override
    public ResponseEntity<OutputMetadataDto> setModerationStatus(UUID metadataId, InputModerationStatusDto inputModerationStatusDto) {
        OutputMetadataDto outputMetadataDto = metadataModerationService.setModerationStatus(metadataId, inputModerationStatusDto);
        return ResponseEntity.ok(outputMetadataDto);
    }
}
