package com.finconsgroup.itserr.marketplace.metadata.bs.controller;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.api.MetadataApi;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.InputCreateMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.InputUpdateMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.MetadataCategoryEnum;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.MetadataStatus;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataFieldDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataFieldExtDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataPreviewDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.service.MetadataService;
import lombok.RequiredArgsConstructor;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

import java.util.UUID;

/**
 * Metadata controller.
 */
@RestController
@RequiredArgsConstructor
public class MetadataController implements MetadataApi {

    private final MetadataService metadataService;

    @Override
    public ResponseEntity<OutputPageDto<OutputMetadataPreviewDto>> findAll(
        String name,
        MetadataCategoryEnum category,
        int pageNumber,
        int pageSize,
        String sort,
        Sort.Direction direction) {
        return ResponseEntity.ok(metadataService.findAll(name, category, pageNumber, pageSize, sort, direction));
    }

    @Override
    public ResponseEntity<OutputMetadataDto> findById(UUID metadataId) {
        return ResponseEntity.ok(metadataService.findById(metadataId));
    }

    @Override
    public OutputMetadataDto create(final InputCreateMetadataDto request) {
        return metadataService.create(request);
    }

    @Override
    public OutputMetadataDto update(UUID metadataId, InputUpdateMetadataDto inputUpdateMetadataDto) {
        return metadataService.update(metadataId, inputUpdateMetadataDto);
    }

    @Override
    public OutputMetadataDto deleteById(final UUID id) {
        return metadataService.deleteById(id);
    }

    @Override
    public ResponseEntity<OutputPageDto<OutputMetadataFieldDto>> findAllFieldsById(UUID metadataId, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        return ResponseEntity.ok(metadataService.findAllFieldsById(metadataId, pageNumber, pageSize, sort, direction));
    }

    @Override
    public ResponseEntity<OutputPageDto<OutputMetadataFieldExtDto>> findAllFields(String name, MetadataCategoryEnum category, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        return ResponseEntity.ok(metadataService.findAllFields(name, category, pageNumber, pageSize, sort, direction));
    }

    @Override
    public ResponseEntity<OutputMetadataDto> requestModeration(UUID metadataId) {
        return ResponseEntity.ok(metadataService.requestModeration(metadataId));
    }

    @Override
    public ResponseEntity<OutputPageDto<OutputMetadataDto>> findAllByCreatorId(MetadataStatus status,
                                                                               int pageNumber,
                                                                               int pageSize,
                                                                               String sort,
                                                                               Sort.Direction direction) {
        return ResponseEntity.ok(metadataService.findAllByCreatorId(status, pageNumber, pageSize, sort, direction));
    }
}
