package com.finconsgroup.itserr.marketplace.metadata.bs.bean;

import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.enums.EventType;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import org.springframework.context.ApplicationEvent;
import org.springframework.lang.NonNull;

import java.util.Objects;

/**
 * Application event when a user action is taken on Metadata.
 */
@Getter
@EqualsAndHashCode(callSuper = true)
public class MetadataEvent extends ApplicationEvent {

    private final EventType eventType;

    public MetadataEvent(@NonNull OutputMetadataDto source,
                         @NonNull EventType eventType) {
        super(source);
        Objects.requireNonNull(eventType, "eventType cannot be null");
        this.eventType = eventType;
    }

    /**
     * The metadata on which the event occurred.
     *
     * @return the {@link OutputMetadataDto}
     */
    public OutputMetadataDto getMetadata() {
        return (OutputMetadataDto) getSource();
    }

}
