package com.finconsgroup.itserr.marketplace.metadata.bs.client.userprofile;

import com.finconsgroup.itserr.marketplace.metadata.bs.client.userprofile.dto.UserProfileBsOutputUserProfileDto;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

import java.util.List;

/**
 * Client interface for interacting with the user profile bs microservice.
 */
public interface UserProfileBsClient {

    /**
     * Get the user profiles matching the provided role.
     *
     * @param roleName the role name to search for
     * @return the list of matching {@link UserProfileBsOutputUserProfileDto} and HTTP status 200 (OK)
     */
    @GetMapping(value = "/profiles-by-role", produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseStatus(HttpStatus.OK)
    List<UserProfileBsOutputUserProfileDto> getUserProfilesByRole(
            @RequestParam("roleName") String roleName
    );

}
