package com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.Instant;
import java.util.List;
import java.util.UUID;

/**
 * Metadata DTO.
 */
@Schema(
        name = "Metadata",
        description = "Represents a metadata"
)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputMetadataDmDto {

    /**
     * Name field length.
     */
    public static final int NAME_LENGTH = 50;
    /**
     * Description field length.
     */
    public static final int DESCRIPTION_LENGTH = 2000;

    @Schema(
            description = "Metadata id",
            example = "f81d4fae-7dec-11d0-a765-00a0c91e6bf6")
    @NotBlank
    private UUID id;

    @Schema(
            description = "Metadata name",
            example = "Dublin Core (DC)")
    @NotBlank
    @Size(max = NAME_LENGTH)
    private String name;

    @Schema(
            description = "Metadata description",
            example = "Standard metadata for digital resources.")
    @Size(max = DESCRIPTION_LENGTH)
    private String description;

    @Schema(description = "Metadata category")
    private MetadataCategoryDmEnum category;

    @Schema(description = "The ID of the creator", example = "f81d4fae-7dec-11d0-a765-00a0c91e6bf6")
    private UUID creatorId;

    @Schema(description = "Metadata fields")
    @NotEmpty
    private List<OutputMetadataFieldDmDto> fields;

    @Schema(description = "Current status of the metadata", example = "DRAFT")
    private MetadataDmStatus status;

    @Schema(description = "Moderation message", example = "Metadata approved after review")
    private String moderationMessage;

    @Schema(description = "Creation timestamp", example = "2025-11-14T10:00:00Z")
    private Instant createdAt;

    @Schema(description = "Last update timestamp", example = "2025-11-14T10:00:00Z")
    private Instant updatedAt;

    @Schema(description = "User who last updated the metadata", example = "3fa85f64-5717-4562-b3fc-2c963f66afa6")
    private UUID updatedBy;

}
