package com.finconsgroup.itserr.marketplace.metadata.bs.messaging;

import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataDto;
import org.springframework.lang.NonNull;

/**
 * Message Producer responsible for publishing metadata-related resource messages
 */
public interface ResourceProducer {

    /**
     * Publishes a message for approved resource.
     *
     * @param resource the resource that was created
     */
    void publishApprovedResource(@NonNull OutputMetadataDto resource);

    /**
     * Publishes a message for deleted resource.
     *
     * @param resource the resource that was created
     */
    void publishDeletedResource(@NonNull OutputMetadataDto resource);
}
