package com.finconsgroup.itserr.marketplace.metadata.bs.client.userprofile.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.UUID;

/**
 * Output DTO representing a userprofile.
 */
@Schema(name = "OutputUserProfile", description = "DTO representing a userprofile in responses")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class UserProfileBsOutputUserProfileDto {

    @Schema(description = "Unique identifier of the user profile", example = "550e8400-e29b-41d4-a716-446655440000")
    private UUID id;

    @Schema(description = "First name of the user", example = "John")
    private String firstName;

    @Schema(description = "Last name of the user", example = "Doe")
    private String lastName;

    @Schema(description = "Email address of the user", example = "john.doe@example.com")
    private String email;

    @Schema(description = "preferred Username of the user", example = "john.doe.213213")
    private String preferredUsername;

    @Schema(description = "ORCID identifier of the user", example = "0000-0002-1825-0097")
    private String orcid;

}
