package com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto;

import com.finconsgroup.itserr.marketplace.core.web.validation.annotation.ExclusiveMembers;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

import static com.finconsgroup.itserr.marketplace.metadata.bs.constants.Constants.METADATA_FIELD_DESCRIPTION_LENGTH;
import static com.finconsgroup.itserr.marketplace.metadata.bs.constants.Constants.METADATA_FIELD_NAME_LENGTH;

/**
 * Metadata field create request DTO.
 */
@Schema(
        name = "MetadataFieldSaveRequest",
        description = "Metadata field save request"
)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ExclusiveMembers(fields = {"vocabulary", "validation"})
public class InputUpdateMetadataDmFieldDto {

    @Schema(description = "Field name")
    @NotBlank
    @Size(max = METADATA_FIELD_NAME_LENGTH)
    @Pattern(
            regexp = "^[^\\x09\\x0A\\x0B\\x0C\\x0D\\x1C\\x1D\\x1E\\x1F\\x2A\\x2E\\x2F\\x3A\\x5B\\x5D\\x7C]*$",
            message = "Name has invalid characters")
    private String name;

    @Schema(description = "Description")
    @Size(max = METADATA_FIELD_DESCRIPTION_LENGTH)
    private String description;

    @Schema(description = "Type of the field expected value")
    @NotNull
    private OutputMetadataFieldDmType type;

    @Schema(description = """
                List of terms that are allowed as values, or null/empty for any available.
                This should be alternative to 'validation'.
            """)
    private List<String> vocabulary;

    @Schema(description = """
             A regex that the value should comply with.
             This should be alternative to 'vocabulary'.
            """)
    private String validation;

    @Schema(
            description = "true if the metadata value is mandatory, false otherwise",
            defaultValue = "false")
    private boolean mandatory;

    /**
     * Sets name. Name is automatically trimmed.
     *
     * @param name Name. May be null.
     */
    public void setName(final String name) {
        this.name = StringUtils.trim(name);
    }

}
