/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.MetadataDmClient;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.InputCreateMetadataDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.InputUpdateMetadataDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.MetadataCategoryDmEnum;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.MetadataDmStatus;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.OutputMetadataDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.InputCreateMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.InputUpdateMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.MetadataCategoryEnum;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.MetadataStatus;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataFieldDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataFieldExtDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataPreviewDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.exception.MetadataExistsException;
import com.finconsgroup.itserr.marketplace.metadata.bs.mapper.MetadataMapper;
import com.finconsgroup.itserr.marketplace.metadata.bs.messaging.ResourceProducer;
import com.finconsgroup.itserr.marketplace.metadata.bs.service.MetadataService;
import com.finconsgroup.itserr.marketplace.metadata.bs.service.impl.UserProfileHelper;
import feign.FeignException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
public class DefaultMetadataService
implements MetadataService {
    private final MetadataMapper metadataMapper;
    private final MetadataDmClient metadataDmClient;
    private final ResourceProducer resourceProducer;
    private final UserProfileHelper userProfileHelper;

    @NonNull
    public OutputPageDto<OutputMetadataPreviewDto> findAll(MetadataCategoryEnum category, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        MetadataCategoryDmEnum metadataCategoryDmEnum = category != null ? MetadataCategoryDmEnum.fromString((String)category.getValue()) : null;
        Page outputMetadataDmDtoOutputPageDto = this.metadataDmClient.findAll(metadataCategoryDmEnum, pageNumber, pageSize, sort, direction);
        Map userDetails = this.userProfileHelper.fetchUserDetailsFromPreviews(outputMetadataDmDtoOutputPageDto.toList());
        return OutputPageDto.fromPage((Page)outputMetadataDmDtoOutputPageDto).map(dto -> {
            OutputMetadataPreviewDto outputMetadataPreviewDto = this.metadataMapper.clientDtoToDto(dto);
            this.userProfileHelper.enrichMetadataPreviewDto(dto, outputMetadataPreviewDto, userDetails);
            return outputMetadataPreviewDto;
        });
    }

    @NonNull
    public OutputMetadataDto findById(@NonNull UUID metadataId) {
        OutputMetadataDmDto outputMetadataDmDto = this.metadataDmClient.findById(metadataId);
        Map userDetails = this.userProfileHelper.fetchUserDetails(List.of(outputMetadataDmDto));
        OutputMetadataDto outputMetadataDto = this.metadataMapper.clientDtoToDto(outputMetadataDmDto);
        this.userProfileHelper.enrichMetadataDto(outputMetadataDmDto, outputMetadataDto, userDetails);
        return outputMetadataDto;
    }

    @NonNull
    public OutputMetadataDto create(@NotNull InputCreateMetadataDto request) {
        OutputMetadataDto createdMetadata = this.executeCreateMetadata(request);
        this.resourceProducer.publishCreatedResource(createdMetadata);
        return createdMetadata;
    }

    @NonNull
    public OutputMetadataDto update(@NonNull UUID metadataId, @NonNull InputUpdateMetadataDto inputUpdateMetadataDto) {
        InputUpdateMetadataDmDto inputUpdateMetadataDmDto = this.metadataMapper.dtoToClientDto(inputUpdateMetadataDto);
        OutputMetadataDmDto outputMetadataDmDto = this.metadataDmClient.update(metadataId, inputUpdateMetadataDmDto);
        Map userDetails = this.userProfileHelper.fetchUserDetails(List.of(outputMetadataDmDto));
        OutputMetadataDto outputMetadataDto = this.metadataMapper.clientDtoToDto(outputMetadataDmDto);
        this.userProfileHelper.enrichMetadataDto(outputMetadataDmDto, outputMetadataDto, userDetails);
        return outputMetadataDto;
    }

    private OutputMetadataDto executeCreateMetadata(@NotNull InputCreateMetadataDto request) {
        InputCreateMetadataDmDto clientRequest = this.metadataMapper.dtoToClientDto(request);
        try {
            OutputMetadataDmDto createdMetadata = this.metadataDmClient.create(clientRequest);
            Map userDetails = this.userProfileHelper.fetchUserDetails(List.of(createdMetadata));
            OutputMetadataDto outputMetadataDto = this.metadataMapper.clientDtoToDto(createdMetadata);
            this.userProfileHelper.enrichMetadataDto(createdMetadata, outputMetadataDto, userDetails);
            return outputMetadataDto;
        }
        catch (FeignException.Conflict e) {
            throw new MetadataExistsException(request.getName());
        }
    }

    @NotNull
    public OutputMetadataDto deleteById(@NotNull UUID id) {
        OutputMetadataDmDto outputMetadataDmDto = this.metadataDmClient.delete(id);
        Map userDetails = this.userProfileHelper.fetchUserDetails(List.of(outputMetadataDmDto));
        OutputMetadataDto outputMetadataDto = this.metadataMapper.clientDtoToDto(outputMetadataDmDto);
        this.userProfileHelper.enrichMetadataDto(outputMetadataDmDto, outputMetadataDto, userDetails);
        this.resourceProducer.publishDeletedResource(outputMetadataDto.getId());
        return outputMetadataDto;
    }

    @NonNull
    public OutputPageDto<OutputMetadataFieldDto> findAllFieldsById(UUID metadataId, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        Page outputMetadataFieldDmOutputPageDto = this.metadataDmClient.findAllFieldsById(metadataId, pageNumber, pageSize, sort, direction);
        return OutputPageDto.fromPage((Page)outputMetadataFieldDmOutputPageDto).map(arg_0 -> ((MetadataMapper)this.metadataMapper).clientDtoToDto(arg_0));
    }

    @NonNull
    public OutputPageDto<OutputMetadataFieldExtDto> findAllFields(MetadataCategoryEnum category, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        MetadataCategoryDmEnum metadataCategoryDmEnum = category != null ? MetadataCategoryDmEnum.fromString((String)category.getValue()) : null;
        Page outputMetadataFieldExtDmDtoOutputPageDto = this.metadataDmClient.findAllFields(metadataCategoryDmEnum, pageNumber, pageSize, sort, direction);
        Map userDetails = this.userProfileHelper.fetchUserDetailsFromMetadataFieldExt(outputMetadataFieldExtDmDtoOutputPageDto.toList());
        return OutputPageDto.fromPage((Page)outputMetadataFieldExtDmDtoOutputPageDto).map(dto -> {
            OutputMetadataFieldExtDto outputMetadataFieldExtDto = this.metadataMapper.clientDtoToDto(dto);
            this.userProfileHelper.enrichMetadataFieldExtDto(dto, outputMetadataFieldExtDto, userDetails);
            return outputMetadataFieldExtDto;
        });
    }

    @NonNull
    public OutputMetadataDto requestModeration(@NonNull UUID metadataId) {
        OutputMetadataDmDto outputMetadataDmDto = this.metadataDmClient.requestModeration(metadataId);
        Map userDetails = this.userProfileHelper.fetchUserDetails(List.of(outputMetadataDmDto));
        OutputMetadataDto outputMetadataDto = this.metadataMapper.clientDtoToDto(outputMetadataDmDto);
        this.userProfileHelper.enrichMetadataDto(outputMetadataDmDto, outputMetadataDto, userDetails);
        return outputMetadataDto;
    }

    @NonNull
    public OutputPageDto<OutputMetadataDto> findAllByCreatorId(MetadataStatus status, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        MetadataDmStatus metadataDmStatus = status != null ? MetadataDmStatus.fromString((String)status.getValue()) : null;
        OutputPageDto outputMetadataDmDtoOutputPageDto = this.metadataDmClient.findAllByCreatorId(metadataDmStatus, pageNumber, pageSize, sort, direction);
        Map userDetails = this.userProfileHelper.fetchUserDetails(outputMetadataDmDtoOutputPageDto.getContent());
        List<OutputMetadataDto> outputMetadataDtoList = outputMetadataDmDtoOutputPageDto.getContent().stream().map(dto -> {
            OutputMetadataDto outputMetadataDto = this.metadataMapper.clientDtoToDto(dto);
            this.userProfileHelper.enrichMetadataDto(dto, outputMetadataDto, userDetails);
            return outputMetadataDto;
        }).toList();
        OutputPageDto outputMetadataDtoOutputPageDto = OutputPageDto.emptyWithPage((OutputPageDto.Page)outputMetadataDmDtoOutputPageDto.getPage());
        outputMetadataDtoOutputPageDto.setContent(outputMetadataDtoList);
        return outputMetadataDtoOutputPageDto;
    }

    @Generated
    public DefaultMetadataService(MetadataMapper metadataMapper, MetadataDmClient metadataDmClient, ResourceProducer resourceProducer, UserProfileHelper userProfileHelper) {
        this.metadataMapper = metadataMapper;
        this.metadataDmClient = metadataDmClient;
        this.resourceProducer = resourceProducer;
        this.userProfileHelper = userProfileHelper;
    }
}

