/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.bs.service.impl;

import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.MetadataDmClient;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.InputCreateMetadataDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.OutputMetadataDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.InputCreateMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.exception.MetadataExistsException;
import com.finconsgroup.itserr.marketplace.metadata.bs.mapper.MetadataMapper;
import com.finconsgroup.itserr.marketplace.metadata.bs.messaging.ResourceProducer;
import com.finconsgroup.itserr.marketplace.metadata.bs.service.MetadataService;
import feign.FeignException;
import java.util.UUID;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
public class DefaultMetadataService
implements MetadataService {
    private final MetadataMapper metadataMapper;
    private final MetadataDmClient metadataDmClient;
    private final ResourceProducer resourceProducer;

    @NonNull
    public OutputMetadataDto create(@NotNull InputCreateMetadataDto request) {
        OutputMetadataDto createdMetadata = this.executeCreateMetadata(request);
        this.resourceProducer.publishCreatedResource(createdMetadata);
        return createdMetadata;
    }

    private OutputMetadataDto executeCreateMetadata(@NotNull InputCreateMetadataDto request) {
        OutputMetadataDmDto createdMetadata;
        InputCreateMetadataDmDto clientRequest = this.metadataMapper.dtoToClientDto(request);
        try {
            createdMetadata = this.metadataDmClient.create(clientRequest);
        }
        catch (FeignException.Conflict e) {
            throw new MetadataExistsException(request.getName());
        }
        return this.metadataMapper.clientDtoToDto(createdMetadata);
    }

    @NotNull
    public OutputMetadataDto deleteById(@NotNull UUID id) {
        OutputMetadataDto deletedMetadata = this.metadataMapper.clientDtoToDto(this.metadataDmClient.delete(id));
        this.resourceProducer.publishDeletedResource(deletedMetadata.getId());
        return deletedMetadata;
    }

    @Generated
    public DefaultMetadataService(MetadataMapper metadataMapper, MetadataDmClient metadataDmClient, ResourceProducer resourceProducer) {
        this.metadataMapper = metadataMapper;
        this.metadataDmClient = metadataDmClient;
        this.resourceProducer = resourceProducer;
    }
}

