package com.finconsgroup.itserr.marketplace.metadata.bs.messaging.impl;


import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.messaging.ResourceProducer;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

import java.util.UUID;

/**
 * Local stub implementation of {@link ResourceProducer}.
 * <p>
 * This implementation does not send any real messages but logs the invocation for testing purposes.
 */
@ConditionalOnProperty(name = "messaging.enabled", havingValue = "false")
@Component
@Slf4j
public class LoggerResourceProducer implements ResourceProducer {
    @Override
    public void publishCreatedResource(@NonNull OutputMetadataDto resource) {
        log.info("Message dispatch skipped (local profile) - CREATED event for resource: {}", resource);
    }

    @Override
    public void publishDeletedResource(@NonNull UUID documentId) {
        log.info("Message dispatch skipped (local profile) - DELETED event for resource: {}", documentId);
    }
}