package com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm;

import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.InputCreateMetadataDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.OutputMetadataDmDto;
import jakarta.validation.Valid;
import org.springframework.http.MediaType;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.UUID;

/**
 * Metadata DM microservice client.
 */
public interface MetadataDmClient {

    /**
     * Creates a new metadata.
     * @param request Request.
     * @return Created metadata.
     * @throws feign.FeignException.FeignClientException.Conflict if another metadata exists with the same name
     */
    @PostMapping(path = "/metadata", consumes = MediaType.APPLICATION_JSON_VALUE, produces = MediaType.APPLICATION_JSON_VALUE)
    OutputMetadataDmDto create(
            @Valid @RequestBody InputCreateMetadataDmDto request);

    /**
     * Deletes a metadata.
     * @param id Metadata id.
     * @return Deleted metadata.
     * @throws feign.FeignException.FeignClientException.NotFound if the metadata is not found.
     */
    @DeleteMapping(path = "/metadata/{id}", produces = MediaType.APPLICATION_JSON_VALUE)
    OutputMetadataDmDto delete(@NonNull @PathVariable("id") UUID id);

}
