package com.finconsgroup.itserr.marketplace.label.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;

import java.time.Instant;

import static com.finconsgroup.itserr.marketplace.label.dm.util.DomainConstants.CONTEXT_LENGTH;
import static com.finconsgroup.itserr.marketplace.label.dm.util.DomainConstants.LABEL_LENGTH;

/**
 * This entity represents a label.
 */
@Entity
@Table(name = "label")
@SuperBuilder
@Getter
@Setter
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
public class LabelEntity extends AbstractUUIDEntity {

    /**
     * Label name.
     */
    @Column(name = "name", nullable = false, length = LABEL_LENGTH)
    private String name;

    /**
     * Label context.
     */
    @Column(name = "context", nullable = false, length = CONTEXT_LENGTH)
    private String context;

    /**
     * Creation timestamp
     */
    @Column(name = "creation_timestamp", nullable = false)
    private Instant creationTimestamp;

    @Override
    public void prePersist() {
        super.prePersist();
        if (creationTimestamp == null) {
            creationTimestamp = Instant.now();
        }
    }
}
