package com.finconsgroup.itserr.marketplace.label.dm.dto;


import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import static com.finconsgroup.itserr.marketplace.label.dm.util.DomainConstants.CONTEXT_LENGTH;
import static com.finconsgroup.itserr.marketplace.label.dm.util.DomainConstants.LABEL_LENGTH;

/**
 * Label create request dto.
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class InputCreateLabelDto {

    @Schema(
        description = "Label name",
        example = "english")
    @NotBlank
    @Size(max = LABEL_LENGTH)
    private String name;

    @Schema(
        description = "Label context",
        example = "languages")
    @NotBlank
    @Size(max = CONTEXT_LENGTH)
    private String context;
}
