/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputButtonDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputCopyrightDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputParagraphDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputRelatedInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputRepositoriesDto;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

@Schema(name="OutputInstitutionalPageDto", description="Output DTO of an institutionalPage")
public class OutputInstitutionalPageDto {
    @Schema(description="ID of the institutional page", example="11111111-bbbb-0000-0000-000000000000")
    private UUID id;
    @Schema(description="The name of the institutional page", example="Criterion")
    private String name;
    @Schema(description="ID of the workspace folder related to the institutional page", example="22222222-bbbb-0000-0000-000000000000")
    private UUID workspaceFolderId;
    @Schema(description="The parent node of the institutional page")
    private OutputRelatedInstitutionalPageDto parentInstitutionalPage;
    @Schema(description="The child nodes of the institutional page")
    private List<OutputRelatedInstitutionalPageDto> childInstitutionalPages;
    @Schema(description="ID of the root institutional page")
    private UUID rootInstitutionalPageId;
    @Schema(description="Name of the root institutional page")
    private String rootInstitutionalPageName;
    @Schema(description="IDs of the WP leads of the institutional page", example="[\"33333333-aaaa-1111-0000-000000000000\",\"33333333-aaaa-2222-0000-000000000000\"]")
    private List<UUID> wpLeads;
    @Schema(description="IDs of members of the institutional page", example="[\"33333333-aaaa-3333-0000-000000000000\",\"33333333-aaaa-4444-0000-000000000000\"]")
    private List<UUID> members;
    @Schema(description="Indicates whether the institutional page is published", example="true")
    private Boolean published;
    @Schema(description="Indicates whether the institutional page is waiting to be deleted", example="true")
    private Boolean toDelete;
    @Schema(description="Indicates whether the institutional page has an updated version", example="true")
    private Boolean hasUpdatedVersion;
    @Schema(description="The category of the institutional page", allowableValues={"tool", "project"}, example="project")
    private String category;
    @Schema(description="The moderation status of the institutional page", allowableValues={"Draft", "Pending", "Approved", "Rejected"}, example="Pending")
    private String moderationStatus;
    @Schema(description="The moderation status of the parallel version", allowableValues={"Draft", "Pending", "Approved", "Rejected"}, example="Pending")
    private String parallelVersionStatus;
    @Schema(description="The time of publication of the institutional page", example="2025-05-27T14:19:46.606883Z")
    private Instant publicationTime;
    @Schema(description="Message related to rejection of publish process", example="The copyright is not compatible with our standard")
    private String rejectionMessage;
    @Schema(description="The abstract of the institutional page", example="WP3, the Toolkit for Religious Studies (T-ReS), aims to improve the research experience.")
    private String abstractContent;
    @Schema(description="Copyright info for the institutional page")
    private OutputCopyrightDto copyright;
    @Schema(description="ID of the maintainer of the institutional page", example="33333333-aaaa-1111-0000-000000000000")
    private UUID maintainer;
    @Schema(description="The paragraphs related to the institutional page")
    private List<OutputParagraphDto> paragraphs;
    @Schema(description="List of tags", example="[\"aramaic\",\"english\",\"italian\"]")
    private List<String> tags;
    @Schema(description="List of languages", example="[\"English\",\"Italian\",\"German\"]")
    private List<String> languages;
    @Schema(description="The image URL", example="https://picsum.photos/200")
    private String imageUrl;
    @Schema(description="The user manual URL", example="https://www.usermanual.com")
    private String userManualUrl;
    @Schema(description="The FAQs page URL", example="https://www.faqs.com")
    private String faqsUrl;
    @Schema(description="The application version", example="v1.3.0")
    private String applicationVersion;
    @Schema(description="The application type", example="web application")
    private String applicationType;
    @Schema(description="The license name", example="MIT License")
    private String license;
    @Schema(description="The supported operating systems", example="Windows 10+, macOS 12+, Ubuntu 20.04+")
    private String supportedOs;
    @Schema(description="The repository links for the institutional page")
    private OutputRepositoriesDto repositories;
    @Schema(description="Additional arbitrary fields in key-value format", example="{\"developer\": \"John Doe\", \"releaseNotes\": \"Initial beta release\"}")
    private LinkedHashMap<String, String> additionalFields;
    @Schema(description="External links in key-value format", example="{\"Documentation\": \"https://docs.example.com\", \"GitHub\": \"https://github.com/project\"}")
    private LinkedHashMap<String, String> externalLinks;
    @Schema(description="Buttons related to the institutional page")
    private List<OutputButtonDto> buttons;
    @Schema(description="ID of the user who is currently updating the entity", example="11111111-bbbb-0000-0000-000000000000")
    private UUID updateLockedBy;
    @Schema(description="ID of the last user who modified the institutional page", example="33333333-aaaa-1111-0000-000000000000")
    private UUID lastModifiedBy;
    @Schema(description="Created At", example="2025-05-26T14:19:46.606883Z")
    private Instant creationTime;
    @Schema(description="Last Updated At", example="2025-05-27T14:19:46.606883Z")
    private Instant updateTime;

    @Generated
    public static OutputInstitutionalPageDtoBuilder builder() {
        return new OutputInstitutionalPageDtoBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public UUID getWorkspaceFolderId() {
        return this.workspaceFolderId;
    }

    @Generated
    public OutputRelatedInstitutionalPageDto getParentInstitutionalPage() {
        return this.parentInstitutionalPage;
    }

    @Generated
    public List<OutputRelatedInstitutionalPageDto> getChildInstitutionalPages() {
        return this.childInstitutionalPages;
    }

    @Generated
    public UUID getRootInstitutionalPageId() {
        return this.rootInstitutionalPageId;
    }

    @Generated
    public String getRootInstitutionalPageName() {
        return this.rootInstitutionalPageName;
    }

    @Generated
    public List<UUID> getWpLeads() {
        return this.wpLeads;
    }

    @Generated
    public List<UUID> getMembers() {
        return this.members;
    }

    @Generated
    public Boolean getPublished() {
        return this.published;
    }

    @Generated
    public Boolean getToDelete() {
        return this.toDelete;
    }

    @Generated
    public Boolean getHasUpdatedVersion() {
        return this.hasUpdatedVersion;
    }

    @Generated
    public String getCategory() {
        return this.category;
    }

    @Generated
    public String getModerationStatus() {
        return this.moderationStatus;
    }

    @Generated
    public String getParallelVersionStatus() {
        return this.parallelVersionStatus;
    }

    @Generated
    public Instant getPublicationTime() {
        return this.publicationTime;
    }

    @Generated
    public String getRejectionMessage() {
        return this.rejectionMessage;
    }

    @Generated
    public String getAbstractContent() {
        return this.abstractContent;
    }

    @Generated
    public OutputCopyrightDto getCopyright() {
        return this.copyright;
    }

    @Generated
    public UUID getMaintainer() {
        return this.maintainer;
    }

    @Generated
    public List<OutputParagraphDto> getParagraphs() {
        return this.paragraphs;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @Generated
    public List<String> getLanguages() {
        return this.languages;
    }

    @Generated
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Generated
    public String getUserManualUrl() {
        return this.userManualUrl;
    }

    @Generated
    public String getFaqsUrl() {
        return this.faqsUrl;
    }

    @Generated
    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    @Generated
    public String getApplicationType() {
        return this.applicationType;
    }

    @Generated
    public String getLicense() {
        return this.license;
    }

    @Generated
    public String getSupportedOs() {
        return this.supportedOs;
    }

    @Generated
    public OutputRepositoriesDto getRepositories() {
        return this.repositories;
    }

    @Generated
    public LinkedHashMap<String, String> getAdditionalFields() {
        return this.additionalFields;
    }

    @Generated
    public LinkedHashMap<String, String> getExternalLinks() {
        return this.externalLinks;
    }

    @Generated
    public List<OutputButtonDto> getButtons() {
        return this.buttons;
    }

    @Generated
    public UUID getUpdateLockedBy() {
        return this.updateLockedBy;
    }

    @Generated
    public UUID getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    @Generated
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public Instant getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setWorkspaceFolderId(UUID workspaceFolderId) {
        this.workspaceFolderId = workspaceFolderId;
    }

    @Generated
    public void setParentInstitutionalPage(OutputRelatedInstitutionalPageDto parentInstitutionalPage) {
        this.parentInstitutionalPage = parentInstitutionalPage;
    }

    @Generated
    public void setChildInstitutionalPages(List<OutputRelatedInstitutionalPageDto> childInstitutionalPages) {
        this.childInstitutionalPages = childInstitutionalPages;
    }

    @Generated
    public void setRootInstitutionalPageId(UUID rootInstitutionalPageId) {
        this.rootInstitutionalPageId = rootInstitutionalPageId;
    }

    @Generated
    public void setRootInstitutionalPageName(String rootInstitutionalPageName) {
        this.rootInstitutionalPageName = rootInstitutionalPageName;
    }

    @Generated
    public void setWpLeads(List<UUID> wpLeads) {
        this.wpLeads = wpLeads;
    }

    @Generated
    public void setMembers(List<UUID> members) {
        this.members = members;
    }

    @Generated
    public void setPublished(Boolean published) {
        this.published = published;
    }

    @Generated
    public void setToDelete(Boolean toDelete) {
        this.toDelete = toDelete;
    }

    @Generated
    public void setHasUpdatedVersion(Boolean hasUpdatedVersion) {
        this.hasUpdatedVersion = hasUpdatedVersion;
    }

    @Generated
    public void setCategory(String category) {
        this.category = category;
    }

    @Generated
    public void setModerationStatus(String moderationStatus) {
        this.moderationStatus = moderationStatus;
    }

    @Generated
    public void setParallelVersionStatus(String parallelVersionStatus) {
        this.parallelVersionStatus = parallelVersionStatus;
    }

    @Generated
    public void setPublicationTime(Instant publicationTime) {
        this.publicationTime = publicationTime;
    }

    @Generated
    public void setRejectionMessage(String rejectionMessage) {
        this.rejectionMessage = rejectionMessage;
    }

    @Generated
    public void setAbstractContent(String abstractContent) {
        this.abstractContent = abstractContent;
    }

    @Generated
    public void setCopyright(OutputCopyrightDto copyright) {
        this.copyright = copyright;
    }

    @Generated
    public void setMaintainer(UUID maintainer) {
        this.maintainer = maintainer;
    }

    @Generated
    public void setParagraphs(List<OutputParagraphDto> paragraphs) {
        this.paragraphs = paragraphs;
    }

    @Generated
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setLanguages(List<String> languages) {
        this.languages = languages;
    }

    @Generated
    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    @Generated
    public void setUserManualUrl(String userManualUrl) {
        this.userManualUrl = userManualUrl;
    }

    @Generated
    public void setFaqsUrl(String faqsUrl) {
        this.faqsUrl = faqsUrl;
    }

    @Generated
    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    @Generated
    public void setApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    @Generated
    public void setLicense(String license) {
        this.license = license;
    }

    @Generated
    public void setSupportedOs(String supportedOs) {
        this.supportedOs = supportedOs;
    }

    @Generated
    public void setRepositories(OutputRepositoriesDto repositories) {
        this.repositories = repositories;
    }

    @Generated
    public void setAdditionalFields(LinkedHashMap<String, String> additionalFields) {
        this.additionalFields = additionalFields;
    }

    @Generated
    public void setExternalLinks(LinkedHashMap<String, String> externalLinks) {
        this.externalLinks = externalLinks;
    }

    @Generated
    public void setButtons(List<OutputButtonDto> buttons) {
        this.buttons = buttons;
    }

    @Generated
    public void setUpdateLockedBy(UUID updateLockedBy) {
        this.updateLockedBy = updateLockedBy;
    }

    @Generated
    public void setLastModifiedBy(UUID lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    @Generated
    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(Instant updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutputInstitutionalPageDto)) {
            return false;
        }
        OutputInstitutionalPageDto other = (OutputInstitutionalPageDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$published = this.getPublished();
        Boolean other$published = other.getPublished();
        if (this$published == null ? other$published != null : !((Object)this$published).equals(other$published)) {
            return false;
        }
        Boolean this$toDelete = this.getToDelete();
        Boolean other$toDelete = other.getToDelete();
        if (this$toDelete == null ? other$toDelete != null : !((Object)this$toDelete).equals(other$toDelete)) {
            return false;
        }
        Boolean this$hasUpdatedVersion = this.getHasUpdatedVersion();
        Boolean other$hasUpdatedVersion = other.getHasUpdatedVersion();
        if (this$hasUpdatedVersion == null ? other$hasUpdatedVersion != null : !((Object)this$hasUpdatedVersion).equals(other$hasUpdatedVersion)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        UUID this$workspaceFolderId = this.getWorkspaceFolderId();
        UUID other$workspaceFolderId = other.getWorkspaceFolderId();
        if (this$workspaceFolderId == null ? other$workspaceFolderId != null : !((Object)this$workspaceFolderId).equals(other$workspaceFolderId)) {
            return false;
        }
        OutputRelatedInstitutionalPageDto this$parentInstitutionalPage = this.getParentInstitutionalPage();
        OutputRelatedInstitutionalPageDto other$parentInstitutionalPage = other.getParentInstitutionalPage();
        if (this$parentInstitutionalPage == null ? other$parentInstitutionalPage != null : !this$parentInstitutionalPage.equals(other$parentInstitutionalPage)) {
            return false;
        }
        List this$childInstitutionalPages = this.getChildInstitutionalPages();
        List other$childInstitutionalPages = other.getChildInstitutionalPages();
        if (this$childInstitutionalPages == null ? other$childInstitutionalPages != null : !((Object)this$childInstitutionalPages).equals(other$childInstitutionalPages)) {
            return false;
        }
        UUID this$rootInstitutionalPageId = this.getRootInstitutionalPageId();
        UUID other$rootInstitutionalPageId = other.getRootInstitutionalPageId();
        if (this$rootInstitutionalPageId == null ? other$rootInstitutionalPageId != null : !((Object)this$rootInstitutionalPageId).equals(other$rootInstitutionalPageId)) {
            return false;
        }
        String this$rootInstitutionalPageName = this.getRootInstitutionalPageName();
        String other$rootInstitutionalPageName = other.getRootInstitutionalPageName();
        if (this$rootInstitutionalPageName == null ? other$rootInstitutionalPageName != null : !this$rootInstitutionalPageName.equals(other$rootInstitutionalPageName)) {
            return false;
        }
        List this$wpLeads = this.getWpLeads();
        List other$wpLeads = other.getWpLeads();
        if (this$wpLeads == null ? other$wpLeads != null : !((Object)this$wpLeads).equals(other$wpLeads)) {
            return false;
        }
        List this$members = this.getMembers();
        List other$members = other.getMembers();
        if (this$members == null ? other$members != null : !((Object)this$members).equals(other$members)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$moderationStatus = this.getModerationStatus();
        String other$moderationStatus = other.getModerationStatus();
        if (this$moderationStatus == null ? other$moderationStatus != null : !this$moderationStatus.equals(other$moderationStatus)) {
            return false;
        }
        String this$parallelVersionStatus = this.getParallelVersionStatus();
        String other$parallelVersionStatus = other.getParallelVersionStatus();
        if (this$parallelVersionStatus == null ? other$parallelVersionStatus != null : !this$parallelVersionStatus.equals(other$parallelVersionStatus)) {
            return false;
        }
        Instant this$publicationTime = this.getPublicationTime();
        Instant other$publicationTime = other.getPublicationTime();
        if (this$publicationTime == null ? other$publicationTime != null : !((Object)this$publicationTime).equals(other$publicationTime)) {
            return false;
        }
        String this$rejectionMessage = this.getRejectionMessage();
        String other$rejectionMessage = other.getRejectionMessage();
        if (this$rejectionMessage == null ? other$rejectionMessage != null : !this$rejectionMessage.equals(other$rejectionMessage)) {
            return false;
        }
        String this$abstractContent = this.getAbstractContent();
        String other$abstractContent = other.getAbstractContent();
        if (this$abstractContent == null ? other$abstractContent != null : !this$abstractContent.equals(other$abstractContent)) {
            return false;
        }
        OutputCopyrightDto this$copyright = this.getCopyright();
        OutputCopyrightDto other$copyright = other.getCopyright();
        if (this$copyright == null ? other$copyright != null : !this$copyright.equals(other$copyright)) {
            return false;
        }
        UUID this$maintainer = this.getMaintainer();
        UUID other$maintainer = other.getMaintainer();
        if (this$maintainer == null ? other$maintainer != null : !((Object)this$maintainer).equals(other$maintainer)) {
            return false;
        }
        List this$paragraphs = this.getParagraphs();
        List other$paragraphs = other.getParagraphs();
        if (this$paragraphs == null ? other$paragraphs != null : !((Object)this$paragraphs).equals(other$paragraphs)) {
            return false;
        }
        List this$tags = this.getTags();
        List other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List this$languages = this.getLanguages();
        List other$languages = other.getLanguages();
        if (this$languages == null ? other$languages != null : !((Object)this$languages).equals(other$languages)) {
            return false;
        }
        String this$imageUrl = this.getImageUrl();
        String other$imageUrl = other.getImageUrl();
        if (this$imageUrl == null ? other$imageUrl != null : !this$imageUrl.equals(other$imageUrl)) {
            return false;
        }
        String this$userManualUrl = this.getUserManualUrl();
        String other$userManualUrl = other.getUserManualUrl();
        if (this$userManualUrl == null ? other$userManualUrl != null : !this$userManualUrl.equals(other$userManualUrl)) {
            return false;
        }
        String this$faqsUrl = this.getFaqsUrl();
        String other$faqsUrl = other.getFaqsUrl();
        if (this$faqsUrl == null ? other$faqsUrl != null : !this$faqsUrl.equals(other$faqsUrl)) {
            return false;
        }
        String this$applicationVersion = this.getApplicationVersion();
        String other$applicationVersion = other.getApplicationVersion();
        if (this$applicationVersion == null ? other$applicationVersion != null : !this$applicationVersion.equals(other$applicationVersion)) {
            return false;
        }
        String this$applicationType = this.getApplicationType();
        String other$applicationType = other.getApplicationType();
        if (this$applicationType == null ? other$applicationType != null : !this$applicationType.equals(other$applicationType)) {
            return false;
        }
        String this$license = this.getLicense();
        String other$license = other.getLicense();
        if (this$license == null ? other$license != null : !this$license.equals(other$license)) {
            return false;
        }
        String this$supportedOs = this.getSupportedOs();
        String other$supportedOs = other.getSupportedOs();
        if (this$supportedOs == null ? other$supportedOs != null : !this$supportedOs.equals(other$supportedOs)) {
            return false;
        }
        OutputRepositoriesDto this$repositories = this.getRepositories();
        OutputRepositoriesDto other$repositories = other.getRepositories();
        if (this$repositories == null ? other$repositories != null : !this$repositories.equals(other$repositories)) {
            return false;
        }
        LinkedHashMap this$additionalFields = this.getAdditionalFields();
        LinkedHashMap other$additionalFields = other.getAdditionalFields();
        if (this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields)) {
            return false;
        }
        LinkedHashMap this$externalLinks = this.getExternalLinks();
        LinkedHashMap other$externalLinks = other.getExternalLinks();
        if (this$externalLinks == null ? other$externalLinks != null : !((Object)this$externalLinks).equals(other$externalLinks)) {
            return false;
        }
        List this$buttons = this.getButtons();
        List other$buttons = other.getButtons();
        if (this$buttons == null ? other$buttons != null : !((Object)this$buttons).equals(other$buttons)) {
            return false;
        }
        UUID this$updateLockedBy = this.getUpdateLockedBy();
        UUID other$updateLockedBy = other.getUpdateLockedBy();
        if (this$updateLockedBy == null ? other$updateLockedBy != null : !((Object)this$updateLockedBy).equals(other$updateLockedBy)) {
            return false;
        }
        UUID this$lastModifiedBy = this.getLastModifiedBy();
        UUID other$lastModifiedBy = other.getLastModifiedBy();
        if (this$lastModifiedBy == null ? other$lastModifiedBy != null : !((Object)this$lastModifiedBy).equals(other$lastModifiedBy)) {
            return false;
        }
        Instant this$creationTime = this.getCreationTime();
        Instant other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        Instant this$updateTime = this.getUpdateTime();
        Instant other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OutputInstitutionalPageDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $published = this.getPublished();
        result = result * 59 + ($published == null ? 43 : ((Object)$published).hashCode());
        Boolean $toDelete = this.getToDelete();
        result = result * 59 + ($toDelete == null ? 43 : ((Object)$toDelete).hashCode());
        Boolean $hasUpdatedVersion = this.getHasUpdatedVersion();
        result = result * 59 + ($hasUpdatedVersion == null ? 43 : ((Object)$hasUpdatedVersion).hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        UUID $workspaceFolderId = this.getWorkspaceFolderId();
        result = result * 59 + ($workspaceFolderId == null ? 43 : ((Object)$workspaceFolderId).hashCode());
        OutputRelatedInstitutionalPageDto $parentInstitutionalPage = this.getParentInstitutionalPage();
        result = result * 59 + ($parentInstitutionalPage == null ? 43 : $parentInstitutionalPage.hashCode());
        List $childInstitutionalPages = this.getChildInstitutionalPages();
        result = result * 59 + ($childInstitutionalPages == null ? 43 : ((Object)$childInstitutionalPages).hashCode());
        UUID $rootInstitutionalPageId = this.getRootInstitutionalPageId();
        result = result * 59 + ($rootInstitutionalPageId == null ? 43 : ((Object)$rootInstitutionalPageId).hashCode());
        String $rootInstitutionalPageName = this.getRootInstitutionalPageName();
        result = result * 59 + ($rootInstitutionalPageName == null ? 43 : $rootInstitutionalPageName.hashCode());
        List $wpLeads = this.getWpLeads();
        result = result * 59 + ($wpLeads == null ? 43 : ((Object)$wpLeads).hashCode());
        List $members = this.getMembers();
        result = result * 59 + ($members == null ? 43 : ((Object)$members).hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $moderationStatus = this.getModerationStatus();
        result = result * 59 + ($moderationStatus == null ? 43 : $moderationStatus.hashCode());
        String $parallelVersionStatus = this.getParallelVersionStatus();
        result = result * 59 + ($parallelVersionStatus == null ? 43 : $parallelVersionStatus.hashCode());
        Instant $publicationTime = this.getPublicationTime();
        result = result * 59 + ($publicationTime == null ? 43 : ((Object)$publicationTime).hashCode());
        String $rejectionMessage = this.getRejectionMessage();
        result = result * 59 + ($rejectionMessage == null ? 43 : $rejectionMessage.hashCode());
        String $abstractContent = this.getAbstractContent();
        result = result * 59 + ($abstractContent == null ? 43 : $abstractContent.hashCode());
        OutputCopyrightDto $copyright = this.getCopyright();
        result = result * 59 + ($copyright == null ? 43 : $copyright.hashCode());
        UUID $maintainer = this.getMaintainer();
        result = result * 59 + ($maintainer == null ? 43 : ((Object)$maintainer).hashCode());
        List $paragraphs = this.getParagraphs();
        result = result * 59 + ($paragraphs == null ? 43 : ((Object)$paragraphs).hashCode());
        List $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List $languages = this.getLanguages();
        result = result * 59 + ($languages == null ? 43 : ((Object)$languages).hashCode());
        String $imageUrl = this.getImageUrl();
        result = result * 59 + ($imageUrl == null ? 43 : $imageUrl.hashCode());
        String $userManualUrl = this.getUserManualUrl();
        result = result * 59 + ($userManualUrl == null ? 43 : $userManualUrl.hashCode());
        String $faqsUrl = this.getFaqsUrl();
        result = result * 59 + ($faqsUrl == null ? 43 : $faqsUrl.hashCode());
        String $applicationVersion = this.getApplicationVersion();
        result = result * 59 + ($applicationVersion == null ? 43 : $applicationVersion.hashCode());
        String $applicationType = this.getApplicationType();
        result = result * 59 + ($applicationType == null ? 43 : $applicationType.hashCode());
        String $license = this.getLicense();
        result = result * 59 + ($license == null ? 43 : $license.hashCode());
        String $supportedOs = this.getSupportedOs();
        result = result * 59 + ($supportedOs == null ? 43 : $supportedOs.hashCode());
        OutputRepositoriesDto $repositories = this.getRepositories();
        result = result * 59 + ($repositories == null ? 43 : $repositories.hashCode());
        LinkedHashMap $additionalFields = this.getAdditionalFields();
        result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
        LinkedHashMap $externalLinks = this.getExternalLinks();
        result = result * 59 + ($externalLinks == null ? 43 : ((Object)$externalLinks).hashCode());
        List $buttons = this.getButtons();
        result = result * 59 + ($buttons == null ? 43 : ((Object)$buttons).hashCode());
        UUID $updateLockedBy = this.getUpdateLockedBy();
        result = result * 59 + ($updateLockedBy == null ? 43 : ((Object)$updateLockedBy).hashCode());
        UUID $lastModifiedBy = this.getLastModifiedBy();
        result = result * 59 + ($lastModifiedBy == null ? 43 : ((Object)$lastModifiedBy).hashCode());
        Instant $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        Instant $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OutputInstitutionalPageDto(id=" + String.valueOf(this.getId()) + ", name=" + this.getName() + ", workspaceFolderId=" + String.valueOf(this.getWorkspaceFolderId()) + ", parentInstitutionalPage=" + String.valueOf(this.getParentInstitutionalPage()) + ", childInstitutionalPages=" + String.valueOf(this.getChildInstitutionalPages()) + ", rootInstitutionalPageId=" + String.valueOf(this.getRootInstitutionalPageId()) + ", rootInstitutionalPageName=" + this.getRootInstitutionalPageName() + ", wpLeads=" + String.valueOf(this.getWpLeads()) + ", members=" + String.valueOf(this.getMembers()) + ", published=" + this.getPublished() + ", toDelete=" + this.getToDelete() + ", hasUpdatedVersion=" + this.getHasUpdatedVersion() + ", category=" + this.getCategory() + ", moderationStatus=" + this.getModerationStatus() + ", parallelVersionStatus=" + this.getParallelVersionStatus() + ", publicationTime=" + String.valueOf(this.getPublicationTime()) + ", rejectionMessage=" + this.getRejectionMessage() + ", abstractContent=" + this.getAbstractContent() + ", copyright=" + String.valueOf(this.getCopyright()) + ", maintainer=" + String.valueOf(this.getMaintainer()) + ", paragraphs=" + String.valueOf(this.getParagraphs()) + ", tags=" + String.valueOf(this.getTags()) + ", languages=" + String.valueOf(this.getLanguages()) + ", imageUrl=" + this.getImageUrl() + ", userManualUrl=" + this.getUserManualUrl() + ", faqsUrl=" + this.getFaqsUrl() + ", applicationVersion=" + this.getApplicationVersion() + ", applicationType=" + this.getApplicationType() + ", license=" + this.getLicense() + ", supportedOs=" + this.getSupportedOs() + ", repositories=" + String.valueOf(this.getRepositories()) + ", additionalFields=" + String.valueOf(this.getAdditionalFields()) + ", externalLinks=" + String.valueOf(this.getExternalLinks()) + ", buttons=" + String.valueOf(this.getButtons()) + ", updateLockedBy=" + String.valueOf(this.getUpdateLockedBy()) + ", lastModifiedBy=" + String.valueOf(this.getLastModifiedBy()) + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ")";
    }

    @Generated
    public OutputInstitutionalPageDto(UUID id, String name, UUID workspaceFolderId, OutputRelatedInstitutionalPageDto parentInstitutionalPage, List<OutputRelatedInstitutionalPageDto> childInstitutionalPages, UUID rootInstitutionalPageId, String rootInstitutionalPageName, List<UUID> wpLeads, List<UUID> members, Boolean published, Boolean toDelete, Boolean hasUpdatedVersion, String category, String moderationStatus, String parallelVersionStatus, Instant publicationTime, String rejectionMessage, String abstractContent, OutputCopyrightDto copyright, UUID maintainer, List<OutputParagraphDto> paragraphs, List<String> tags, List<String> languages, String imageUrl, String userManualUrl, String faqsUrl, String applicationVersion, String applicationType, String license, String supportedOs, OutputRepositoriesDto repositories, LinkedHashMap<String, String> additionalFields, LinkedHashMap<String, String> externalLinks, List<OutputButtonDto> buttons, UUID updateLockedBy, UUID lastModifiedBy, Instant creationTime, Instant updateTime) {
        this.id = id;
        this.name = name;
        this.workspaceFolderId = workspaceFolderId;
        this.parentInstitutionalPage = parentInstitutionalPage;
        this.childInstitutionalPages = childInstitutionalPages;
        this.rootInstitutionalPageId = rootInstitutionalPageId;
        this.rootInstitutionalPageName = rootInstitutionalPageName;
        this.wpLeads = wpLeads;
        this.members = members;
        this.published = published;
        this.toDelete = toDelete;
        this.hasUpdatedVersion = hasUpdatedVersion;
        this.category = category;
        this.moderationStatus = moderationStatus;
        this.parallelVersionStatus = parallelVersionStatus;
        this.publicationTime = publicationTime;
        this.rejectionMessage = rejectionMessage;
        this.abstractContent = abstractContent;
        this.copyright = copyright;
        this.maintainer = maintainer;
        this.paragraphs = paragraphs;
        this.tags = tags;
        this.languages = languages;
        this.imageUrl = imageUrl;
        this.userManualUrl = userManualUrl;
        this.faqsUrl = faqsUrl;
        this.applicationVersion = applicationVersion;
        this.applicationType = applicationType;
        this.license = license;
        this.supportedOs = supportedOs;
        this.repositories = repositories;
        this.additionalFields = additionalFields;
        this.externalLinks = externalLinks;
        this.buttons = buttons;
        this.updateLockedBy = updateLockedBy;
        this.lastModifiedBy = lastModifiedBy;
        this.creationTime = creationTime;
        this.updateTime = updateTime;
    }
}

