/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.component;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.component.AssociationLoader;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.component.InstitutionalPageHelper;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.component.MemberHelper;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.InstitutionalPageEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.MemberEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.ParagraphEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.repository.InstitutionalPageRepository;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.repository.ParagraphRepository;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class AssociationLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssociationLoader.class);
    public static final String ALL = "all";
    public static final String ASSOCIATION_ROOT_INSTITUTIONAL_PAGE = "rootInstitutionalPage";
    public static final String ASSOCIATION_PARENT_INSTITUTIONAL_PAGE = "parentInstitutionalPage";
    public static final String ASSOCIATION_WP_LEADS = "wpLeads";
    public static final String ASSOCIATION_MEMBERS = "members";
    public static final String ASSOCIATION_CHILD_INSTITUTIONAL_PAGES = "childInstitutionalPages";
    public static final String ASSOCIATION_PARAGRAPHS = "paragraphs";
    private static final Set<String> DEFAULT_ASSOCIATIONS = Set.of("rootInstitutionalPage", "parentInstitutionalPage", "wpLeads", "members", "childInstitutionalPages", "paragraphs");
    private final InstitutionalPageHelper institutionalPageHelper;
    private final MemberHelper memberHelper;
    private final ParagraphRepository paragraphRepository;
    private final InstitutionalPageRepository institutionalPageRepository;

    public LoadedAssociations loadAssociations(Page<InstitutionalPageEntity> institutionalPageEntityPage, Set<String> associationsToLoadParam) {
        List<UUID> updatedInstitutionalPageIds;
        Set<String> associationsToLoad = associationsToLoadParam.contains("all") ? DEFAULT_ASSOCIATIONS : associationsToLoadParam;
        LoadedAssociations loadedAssociations = new LoadedAssociations();
        LinkedList institutionalPages = new LinkedList(institutionalPageEntityPage.getContent());
        if (institutionalPages.isEmpty()) {
            return loadedAssociations;
        }
        HashMap<UUID, UUID> originalIdToInstitutionalPageIdMap = new HashMap<UUID, UUID>();
        for (Object institutionalPage : institutionalPages) {
            UUID institutionalPageId = institutionalPage.getId();
            UUID originalId = InstitutionalPageHelper.getOriginalInstitutionalPageId((InstitutionalPageEntity)institutionalPage);
            originalIdToInstitutionalPageIdMap.put(originalId, institutionalPageId);
            loadedAssociations.childInstitutionalPagesMap.put(institutionalPageId, new LinkedList());
            loadedAssociations.paragraphMap.put(institutionalPageId, new LinkedList());
        }
        if (associationsToLoad.contains("rootInstitutionalPage")) {
            this.institutionalPageHelper.retrieveOriginalRootsInstitutionalPages(institutionalPages).forEach(root -> loadedAssociations.rootInstitutionalPageMap.put(root.getId(), root));
        }
        if (associationsToLoad.contains("parentInstitutionalPage")) {
            this.institutionalPageHelper.retrieveOriginalParentsInstitutionalPages(institutionalPages).forEach(parent -> loadedAssociations.parentInstitutionalPageMap.put(parent.getId(), parent));
        }
        if (associationsToLoad.contains("childInstitutionalPages")) {
            List childInstitutionalPages = this.institutionalPageHelper.retrieveOriginalChildInstitutionalPages(institutionalPages);
            for (Object childInstitutionalPage : childInstitutionalPages) {
                UUID institutionalPageId = (UUID)originalIdToInstitutionalPageIdMap.get(childInstitutionalPage.getParentInstitutionalPageId());
                ((List)loadedAssociations.childInstitutionalPagesMap.get(institutionalPageId)).add(childInstitutionalPage);
            }
        }
        if (associationsToLoad.contains("paragraphs")) {
            List<UUID> institutionalPageIds = institutionalPages.stream().map(AbstractUUIDEntity::getId).toList();
            List paragraphs = this.paragraphRepository.findAllByInstitutionalPageIdIn(institutionalPageIds);
            for (ParagraphEntity paragraph : paragraphs) {
                UUID institutionalPageId = paragraph.getInstitutionalPageId();
                ((List)loadedAssociations.paragraphMap.get(institutionalPageId)).add(paragraph);
            }
        }
        HashMap loadedInstitutionalPageMap = new HashMap();
        institutionalPages.forEach(institutionalPageEntity -> loadedInstitutionalPageMap.put(institutionalPageEntity.getId(), institutionalPageEntity));
        loadedAssociations.childInstitutionalPagesMap.values().stream().flatMap(Collection::stream).filter(institutionalPageEntity -> !loadedInstitutionalPageMap.containsKey(institutionalPageEntity.getId())).forEach(institutionalPageEntity -> loadedInstitutionalPageMap.put(institutionalPageEntity.getId(), institutionalPageEntity));
        loadedAssociations.parentInstitutionalPageMap.values().stream().filter(institutionalPageEntity -> !loadedInstitutionalPageMap.containsKey(institutionalPageEntity.getId())).forEach(institutionalPageEntity -> loadedInstitutionalPageMap.put(institutionalPageEntity.getId(), institutionalPageEntity));
        HashMap<UUID, List> rootIdToOriginalIdsMap = new HashMap<UUID, List>();
        for (InstitutionalPageEntity institutionalPage : loadedInstitutionalPageMap.values()) {
            UUID originalId = InstitutionalPageHelper.getOriginalInstitutionalPageId((InstitutionalPageEntity)institutionalPage);
            UUID rootId = InstitutionalPageHelper.getRootInstitutionalPageId((InstitutionalPageEntity)institutionalPage);
            rootIdToOriginalIdsMap.computeIfAbsent(rootId, unused -> new LinkedList()).add(originalId);
            loadedAssociations.membersMap.put(originalId, new LinkedList());
            loadedAssociations.wpLeadsMap.put(originalId, new LinkedList());
        }
        if (associationsToLoad.contains("wpLeads")) {
            List wpLeaders = this.memberHelper.retrieveWPLeadersByInstitutionalPages(new LinkedList(loadedInstitutionalPageMap.values()));
            for (MemberEntity wpLeader : wpLeaders) {
                List originalIds = (List)rootIdToOriginalIdsMap.get(wpLeader.getInstitutionalPageId());
                for (UUID originalId : originalIds) {
                    ((List)loadedAssociations.wpLeadsMap.get(originalId)).add(wpLeader);
                }
            }
        }
        if (associationsToLoad.contains("members")) {
            List members = this.memberHelper.retrieveRegularMembersByInstitutionalPages(new LinkedList(loadedInstitutionalPageMap.values()));
            for (MemberEntity member : members) {
                UUID originalId = member.getInstitutionalPageId();
                ((List)loadedAssociations.membersMap.get(originalId)).add(member);
            }
        }
        if (!(updatedInstitutionalPageIds = institutionalPages.stream().map(InstitutionalPageEntity::getUpdatedInstitutionalPageId).filter(Objects::nonNull).toList()).isEmpty()) {
            this.institutionalPageRepository.findAllById(updatedInstitutionalPageIds).forEach(updatedInstitutionalPage -> loadedAssociations.updatedInstitutionalPageMap.put(updatedInstitutionalPage.getId(), updatedInstitutionalPage));
        }
        return loadedAssociations;
    }

    public Associations buildAssociations(InstitutionalPageEntity institutionalPageEntity, Set<String> associationsToLoadParam, LoadedAssociations loadedAssociations) {
        UUID updatedInstitutionalPageId;
        Set<String> associationsToLoad = associationsToLoadParam.contains("all") ? DEFAULT_ASSOCIATIONS : associationsToLoadParam;
        UUID institutionalPageId = institutionalPageEntity.getId();
        UUID originalId = InstitutionalPageHelper.getOriginalInstitutionalPageId((InstitutionalPageEntity)institutionalPageEntity);
        Associations.AssociationsBuilder associationsBuilder = Associations.builder();
        if (associationsToLoad.contains("rootInstitutionalPage")) {
            UUID rootId = InstitutionalPageHelper.getRootInstitutionalPageId((InstitutionalPageEntity)institutionalPageEntity);
            String rootInstitutionalPageName = ((InstitutionalPageEntity)loadedAssociations.rootInstitutionalPageMap.get(rootId)).getName();
            associationsBuilder.rootInstitutionalPageName(rootInstitutionalPageName);
        }
        if (associationsToLoad.contains("parentInstitutionalPage")) {
            InstitutionalPageWithMembers parentInstitutionalPageWithMembers = this.mapToParent(institutionalPageEntity, loadedAssociations);
            associationsBuilder.parentInstitutionalPage(parentInstitutionalPageWithMembers);
        }
        if (associationsToLoad.contains("childInstitutionalPages")) {
            List childInstitutionalPages = AssociationLoader.mapToChildren((UUID)institutionalPageId, (LoadedAssociations)loadedAssociations);
            associationsBuilder.childInstitutionalPages(childInstitutionalPages);
        }
        if (associationsToLoad.contains("paragraphs")) {
            associationsBuilder.paragraphs((List)loadedAssociations.paragraphMap.getOrDefault(institutionalPageId, new LinkedList()));
        }
        if (associationsToLoad.contains("wpLeads")) {
            associationsBuilder.wpLeads((List)loadedAssociations.wpLeadsMap.getOrDefault(originalId, new LinkedList()));
        }
        if (associationsToLoad.contains("members")) {
            associationsBuilder.members((List)loadedAssociations.membersMap.getOrDefault(originalId, new LinkedList()));
        }
        if ((updatedInstitutionalPageId = institutionalPageEntity.getUpdatedInstitutionalPageId()) != null) {
            associationsBuilder.updatedInstitutionalPage((InstitutionalPageEntity)loadedAssociations.updatedInstitutionalPageMap.get(updatedInstitutionalPageId));
        }
        return associationsBuilder.build();
    }

    public InstitutionalPageWithMembers mapToParent(InstitutionalPageEntity institutionalPageEntity, LoadedAssociations loadedAssociations) {
        UUID parentInstitutionalPageId = institutionalPageEntity.getParentInstitutionalPageId();
        if (parentInstitutionalPageId == null) {
            return null;
        }
        InstitutionalPageEntity parentInstitutionalPage = (InstitutionalPageEntity)loadedAssociations.parentInstitutionalPageMap.get(parentInstitutionalPageId);
        LinkedList wpLeaderEntities = new LinkedList(loadedAssociations.wpLeadsMap.getOrDefault(parentInstitutionalPageId, new LinkedList()));
        LinkedList memberEntities = new LinkedList(loadedAssociations.membersMap.getOrDefault(parentInstitutionalPageId, new LinkedList()));
        return InstitutionalPageWithMembers.builder().institutionalPage(parentInstitutionalPage).wpLeads(wpLeaderEntities).members(memberEntities).build();
    }

    private static List<InstitutionalPageWithMembers> mapToChildren(UUID institutionalPageId, LoadedAssociations loadedAssociations) {
        List childInstitutionalPages = (List)loadedAssociations.childInstitutionalPagesMap.get(institutionalPageId);
        return childInstitutionalPages.stream().map(childInstitutionalPageEntity -> {
            UUID childOriginalId = InstitutionalPageHelper.getOriginalInstitutionalPageId((InstitutionalPageEntity)childInstitutionalPageEntity);
            LinkedList wpLeaderEntities = new LinkedList(loadedAssociations.wpLeadsMap.getOrDefault(childOriginalId, new LinkedList()));
            LinkedList memberEntities = new LinkedList(loadedAssociations.membersMap.getOrDefault(childOriginalId, new LinkedList()));
            return InstitutionalPageWithMembers.builder().institutionalPage(childInstitutionalPageEntity).wpLeads(wpLeaderEntities).members(memberEntities).build();
        }).toList();
    }

    @Generated
    public AssociationLoader(InstitutionalPageHelper institutionalPageHelper, MemberHelper memberHelper, ParagraphRepository paragraphRepository, InstitutionalPageRepository institutionalPageRepository) {
        this.institutionalPageHelper = institutionalPageHelper;
        this.memberHelper = memberHelper;
        this.paragraphRepository = paragraphRepository;
        this.institutionalPageRepository = institutionalPageRepository;
    }
}

