package com.finconsgroup.itserr.marketplace.institutionalpage.dm.converter;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.ModerationStatus;
import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;

@Converter(autoApply = true)
public class ModerationStatusConverter implements AttributeConverter<ModerationStatus, String> {

    @Override
    public String convertToDatabaseColumn(ModerationStatus attribute) {
        return attribute != null ? attribute.getLabel() : null;
    }

    @Override
    public ModerationStatus convertToEntityAttribute(String dbData) {
        return ModerationStatus.ofLabel(dbData);
    }
}
