/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.api.InstitutionalPageApi;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputCreateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputSearchForMemberInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputUpdateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputRequestUpdateDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.InstitutionalPageView;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.service.InstitutionalPageService;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class InstitutionalPageController
implements InstitutionalPageApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstitutionalPageController.class);
    private final InstitutionalPageService institutionalPageService;

    public OutputInstitutionalPageDto createInstitutionalPage(InputCreateInstitutionalPageDto inputCreateInstitutionalPageDto) {
        log.debug("POST /api/v1/dm/institutional-page/institutional-pages, inputCreateInstitutionalPageDto: {}", (Object)inputCreateInstitutionalPageDto);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.institutionalPageService.createInstitutionalPage(userId, inputCreateInstitutionalPageDto);
    }

    public Page<OutputInstitutionalPageDto> findAllInstitutionalPages(InstitutionalPageView view, boolean includePublishedAndNotMember, Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        log.debug("GET /api/v1/dm/institutional-page/institutional-pages, view: {}, includePublishedAndNotMember: {}", (Object)view, (Object)includePublishedAndNotMember);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[]{sort});
        return this.institutionalPageService.findAllInstitutionalPages(userId, view, includePublishedAndNotMember, associationsToLoad, (Pageable)pageable);
    }

    public Page<OutputInstitutionalPageDto> search(InstitutionalPageView view, InputSearchForMemberInstitutionalPageDto inputSearchForMemberInstitutionalPageDto, Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        log.debug("POST /api/v1/dm/institutional-page/institutional-pages/search, view: {}, inputSearchForMemberInstitutionalPageDto: {}", (Object)view, (Object)inputSearchForMemberInstitutionalPageDto);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[]{sort});
        return this.institutionalPageService.searchInstitutionalPages(userId, view, associationsToLoad, (Pageable)pageable, inputSearchForMemberInstitutionalPageDto);
    }

    public OutputInstitutionalPageDto findInstitutionalPageById(UUID institutionalPageId, InstitutionalPageView view, boolean includePublishedAndNotMember) {
        log.debug("GET /api/v1/dm/institutional-page/institutional-pages/{}, view: {}, includePublishedAndNotMember: {}", new Object[]{institutionalPageId, view, includePublishedAndNotMember});
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.institutionalPageService.findInstitutionalPageById(userId, institutionalPageId, view, includePublishedAndNotMember);
    }

    public OutputInstitutionalPageDto updateInstitutionalPageById(UUID institutionalPageId, InputUpdateInstitutionalPageDto inputUpdateInstitutionalPageDto) {
        log.debug("PUT /api/v1/dm/institutional-page/institutional-pages/{}, inputUpdateInstitutionalPageDto: {}", (Object)institutionalPageId, (Object)inputUpdateInstitutionalPageDto);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.institutionalPageService.updateInstitutionalPageById(userId, institutionalPageId, inputUpdateInstitutionalPageDto);
    }

    public OutputInstitutionalPageDto deleteInstitutionalPageById(UUID institutionalPageId) {
        log.debug("DELETE /api/v1/dm/institutional-page/institutional-pages/{}", (Object)institutionalPageId);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.institutionalPageService.deleteInstitutionalPageById(userId, institutionalPageId);
    }

    public Page<OutputInstitutionalPageDto> findInstitutionalPagesHierarchyByRootId(UUID rootInstitutionalPageId, Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        log.debug("GET /api/v1/dm//institutional-page/institutional-pages/{institutionalPageId}/hierarchy");
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[]{sort});
        return this.institutionalPageService.findInstitutionalPagesHierarchyByRootId(userId, associationsToLoad, (Pageable)pageable, rootInstitutionalPageId);
    }

    public OutputInstitutionalPageDto updateFolderId(UUID institutionalPageId, UUID newFolderId) {
        log.debug("PUT /api/v1/dm/institutional-page/institutional-pages/{}/folders/{}", (Object)institutionalPageId, (Object)newFolderId);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.institutionalPageService.updateFolderId(userId, institutionalPageId, newFolderId);
    }

    public OutputInstitutionalPageDto requestModerationInstitutionalPageById(UUID institutionalPageId) {
        log.debug("PUT /api/v1/dm/institutional-page/institutional-pages/{}/request-moderation", (Object)institutionalPageId);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.institutionalPageService.requestModerationInstitutionalPage(userId, institutionalPageId);
    }

    public OutputInstitutionalPageDto requestPublicationInstitutionalPageById(UUID institutionalPageId) {
        log.debug("PUT /api/v1/dm/institutional-page/institutional-pages/{}/request-publication", (Object)institutionalPageId);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.institutionalPageService.requestPublicationInstitutionalPage(userId, institutionalPageId);
    }

    public OutputRequestUpdateDto requestUpdateInstitutionalPageById(UUID institutionalPageId) {
        log.debug("PUT /api/v1/dm/institutional-page/institutional-pages/{}/request-update", (Object)institutionalPageId);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.institutionalPageService.requestUpdateInstitutionalPageById(userId, institutionalPageId);
    }

    public void cancelUpdateInstitutionalPageById(UUID institutionalPageId) {
        log.debug("PUT /api/v1/dm/institutional-page/institutional-pages/{}/cancel-update", (Object)institutionalPageId);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        this.institutionalPageService.cancelUpdateInstitutionalPageById(userId, institutionalPageId);
    }

    @Generated
    public InstitutionalPageController(InstitutionalPageService institutionalPageService) {
        this.institutionalPageService = institutionalPageService;
    }
}

