package com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.UUID;

/**
 * Output DTO of a request-update operation.
 */
@Schema(name = "OutputRequestUpdateDto", description = "Output DTO of a request-update operation")
@Data
@Builder
@AllArgsConstructor
public class OutputRequestUpdateDto {

    @Schema(description = "Indicates whether the lock for update has been obtained", example = "true")
    private Boolean updateLockObtained;

    @Schema(description = "ID of the user who is currently updating the entity", example = "11111111-bbbb-0000-0000-000000000000")
    private UUID updateLockedBy;

}
