/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputParagraphDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;

@Schema(name="InputParagraphDto", description="Input DTO of a paragraph related to the institutional page")
public class InputParagraphDto {
    @Schema(description="The title of the paragraph", example="Outcomes")
    @NotBlank(message="Required field")
    @Size(max=255, message="Field length must be between {min} and {max}")
    private @NotBlank(message="Required field") @Size(max=255, message="Field length must be between {min} and {max}") String title;
    @Schema(description="The content of the paragraph", example="A shared library of reusable software components")
    @Size(max=8000, message="Field length must be between {min} and {max}")
    private @Size(max=8000, message="Field length must be between {min} and {max}") String content;
    @Schema(description="The image url of the paragraph", example="https://picsum.photos/200")
    @Size(max=2048, message="Field length must be between {min} and {max}")
    private @Size(max=2048, message="Field length must be between {min} and {max}") String imageUrl;
    @Schema(description="The resource url of the paragraph", example="https://www.example.com/")
    @Size(max=2048, message="Field length must be between {min} and {max}")
    private @Size(max=2048, message="Field length must be between {min} and {max}") String resourceUrl;
    @Schema(description="list of labels related to the paragraph", example="[\"god\",\"marriage\"]")
    private List<@NotBlank(message="Required field") @Size(max=255, message="Field length must be between {min} and {max}") String> labels;

    @Generated
    public static InputParagraphDtoBuilder builder() {
        return new InputParagraphDtoBuilder();
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Generated
    public String getResourceUrl() {
        return this.resourceUrl;
    }

    @Generated
    public List<@NotBlank(message="Required field") @Size(max=255, message="Field length must be between {min} and {max}") String> getLabels() {
        return this.labels;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    @Generated
    public void setResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
    }

    @Generated
    public void setLabels(List<@NotBlank(message="Required field") @Size(max=255, message="Field length must be between {min} and {max}") String> labels) {
        this.labels = labels;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputParagraphDto)) {
            return false;
        }
        InputParagraphDto other = (InputParagraphDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$imageUrl = this.getImageUrl();
        String other$imageUrl = other.getImageUrl();
        if (this$imageUrl == null ? other$imageUrl != null : !this$imageUrl.equals(other$imageUrl)) {
            return false;
        }
        String this$resourceUrl = this.getResourceUrl();
        String other$resourceUrl = other.getResourceUrl();
        if (this$resourceUrl == null ? other$resourceUrl != null : !this$resourceUrl.equals(other$resourceUrl)) {
            return false;
        }
        List this$labels = this.getLabels();
        List other$labels = other.getLabels();
        return !(this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InputParagraphDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $imageUrl = this.getImageUrl();
        result = result * 59 + ($imageUrl == null ? 43 : $imageUrl.hashCode());
        String $resourceUrl = this.getResourceUrl();
        result = result * 59 + ($resourceUrl == null ? 43 : $resourceUrl.hashCode());
        List $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InputParagraphDto(title=" + this.getTitle() + ", content=" + this.getContent() + ", imageUrl=" + this.getImageUrl() + ", resourceUrl=" + this.getResourceUrl() + ", labels=" + String.valueOf(this.getLabels()) + ")";
    }

    @Generated
    public InputParagraphDto(String title, String content, String imageUrl, String resourceUrl, List<@NotBlank(message="Required field") @Size(max=255, message="Field length must be between {min} and {max}") String> labels) {
        this.title = title;
        this.content = content;
        this.imageUrl = imageUrl;
        this.resourceUrl = resourceUrl;
        this.labels = labels;
    }
}

