package com.finconsgroup.itserr.marketplace.institutionalpage.dm.mapper;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputParagraphDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputParagraphDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.ParagraphEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2026-02-13T06:37:21+0000",
    comments = "version: 1.6.3, compiler: javac, environment: Java 21.0.9 (Eclipse Adoptium)"
)
@Component
public class ParagraphMapperImpl implements ParagraphMapper {

    @Override
    public ParagraphEntity toEntity(InputParagraphDto model) {
        if ( model == null ) {
            return null;
        }

        ParagraphEntity.ParagraphEntityBuilder<?, ?> paragraphEntity = ParagraphEntity.builder();

        paragraphEntity.title( model.getTitle() );
        paragraphEntity.content( model.getContent() );
        paragraphEntity.imageUrl( model.getImageUrl() );
        paragraphEntity.resourceUrl( model.getResourceUrl() );
        List<String> list = model.getLabels();
        if ( list != null ) {
            paragraphEntity.labels( new ArrayList<String>( list ) );
        }

        return paragraphEntity.build();
    }

    @Override
    public OutputParagraphDto toDto(ParagraphEntity entity) {
        if ( entity == null ) {
            return null;
        }

        OutputParagraphDto.OutputParagraphDtoBuilder outputParagraphDto = OutputParagraphDto.builder();

        outputParagraphDto.id( entity.getId() );
        outputParagraphDto.title( entity.getTitle() );
        outputParagraphDto.content( entity.getContent() );
        outputParagraphDto.imageUrl( entity.getImageUrl() );
        outputParagraphDto.resourceUrl( entity.getResourceUrl() );
        List<String> list = entity.getLabels();
        if ( list != null ) {
            outputParagraphDto.labels( new ArrayList<String>( list ) );
        }

        return outputParagraphDto.build();
    }

    @Override
    public void updateEntity(ParagraphEntity entity, InputParagraphDto inputParagraphDto) {
        if ( inputParagraphDto == null ) {
            return;
        }

        entity.setTitle( inputParagraphDto.getTitle() );
        entity.setContent( inputParagraphDto.getContent() );
        entity.setImageUrl( inputParagraphDto.getImageUrl() );
        entity.setResourceUrl( inputParagraphDto.getResourceUrl() );
        if ( entity.getLabels() != null ) {
            List<String> list = inputParagraphDto.getLabels();
            if ( list != null ) {
                entity.getLabels().clear();
                entity.getLabels().addAll( list );
            }
            else {
                entity.setLabels( null );
            }
        }
        else {
            List<String> list = inputParagraphDto.getLabels();
            if ( list != null ) {
                entity.setLabels( new ArrayList<String>( list ) );
            }
        }
    }

    @Override
    public List<ParagraphEntity> cloneParagraphList(List<ParagraphEntity> src) {
        if ( src == null ) {
            return null;
        }

        List<ParagraphEntity> list = new ArrayList<ParagraphEntity>( src.size() );
        for ( ParagraphEntity paragraphEntity : src ) {
            list.add( cloneParagraph( paragraphEntity ) );
        }

        return list;
    }

    @Override
    public List<ParagraphEntity> inputParagraphListToParagraphEntityList(List<InputParagraphDto> src) {
        if ( src == null ) {
            return null;
        }

        List<ParagraphEntity> list = new ArrayList<ParagraphEntity>( src.size() );
        for ( InputParagraphDto inputParagraphDto : src ) {
            list.add( toEntity( inputParagraphDto ) );
        }

        return list;
    }

    @Override
    public ParagraphEntity cloneParagraph(ParagraphEntity paragraph) {
        if ( paragraph == null ) {
            return null;
        }

        ParagraphEntity.ParagraphEntityBuilder<?, ?> paragraphEntity = ParagraphEntity.builder();

        paragraphEntity.institutionalPageId( paragraph.getInstitutionalPageId() );
        paragraphEntity.title( paragraph.getTitle() );
        paragraphEntity.content( paragraph.getContent() );
        paragraphEntity.imageUrl( paragraph.getImageUrl() );
        paragraphEntity.resourceUrl( paragraph.getResourceUrl() );
        List<String> list = paragraph.getLabels();
        if ( list != null ) {
            paragraphEntity.labels( new ArrayList<String>( list ) );
        }
        paragraphEntity.creationTime( paragraph.getCreationTime() );
        paragraphEntity.updateTime( paragraph.getUpdateTime() );

        return paragraphEntity.build();
    }
}
