package com.finconsgroup.itserr.marketplace.institutionalpage.dm.mapper;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputButtonDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputCopyrightDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputCreateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputRepositoriesDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputSearchForMemberInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputSearchModerationInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputSearchPublishedInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputUpdateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputButtonDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputCopyrightDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputRelatedInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputRepositoriesDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.InstitutionalPageEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.ParagraphEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.InstitutionalPageView;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.ModerationStatus;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.model.ButtonModel;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.model.SearchForMemberInstitutionalPageModel;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.model.SearchInstitutionalPageModel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2026-02-13T06:37:21+0000",
    comments = "version: 1.6.3, compiler: javac, environment: Java 21.0.9 (Eclipse Adoptium)"
)
@Component
public class InstitutionalPageMapperImpl implements InstitutionalPageMapper {

    @Autowired
    private ParagraphMapper paragraphMapper;

    @Override
    public InstitutionalPageEntity toEntity(InputCreateInstitutionalPageDto dto) {
        if ( dto == null ) {
            return null;
        }

        InstitutionalPageEntity.InstitutionalPageEntityBuilder<?, ?> institutionalPageEntity = InstitutionalPageEntity.builder();

        institutionalPageEntity.copyrightText( dtoCopyrightText( dto ) );
        Integer year = dtoCopyrightYear( dto );
        if ( year != null ) {
            institutionalPageEntity.copyrightYear( year );
        }
        institutionalPageEntity.repoName( dtoRepositoriesRepoName( dto ) );
        institutionalPageEntity.website( dtoRepositoriesWebsite( dto ) );
        institutionalPageEntity.name( dto.getName() );
        institutionalPageEntity.workspaceFolderId( dto.getWorkspaceFolderId() );
        institutionalPageEntity.paragraphs( paragraphMapper.inputParagraphListToParagraphEntityList( dto.getParagraphs() ) );
        institutionalPageEntity.category( dto.getCategory() );
        if ( dto.getPublished() != null ) {
            institutionalPageEntity.published( dto.getPublished() );
        }
        institutionalPageEntity.abstractContent( dto.getAbstractContent() );
        List<String> list1 = dto.getTags();
        if ( list1 != null ) {
            institutionalPageEntity.tags( new ArrayList<String>( list1 ) );
        }
        List<String> list2 = dto.getLanguages();
        if ( list2 != null ) {
            institutionalPageEntity.languages( new ArrayList<String>( list2 ) );
        }
        institutionalPageEntity.imageUrl( dto.getImageUrl() );
        institutionalPageEntity.userManualUrl( dto.getUserManualUrl() );
        institutionalPageEntity.faqsUrl( dto.getFaqsUrl() );
        institutionalPageEntity.applicationVersion( dto.getApplicationVersion() );
        institutionalPageEntity.applicationType( dto.getApplicationType() );
        institutionalPageEntity.license( dto.getLicense() );
        institutionalPageEntity.supportedOs( dto.getSupportedOs() );
        LinkedHashMap<String, String> linkedHashMap = dto.getAdditionalFields();
        if ( linkedHashMap != null ) {
            institutionalPageEntity.additionalFields( new LinkedHashMap<String, String>( linkedHashMap ) );
        }
        LinkedHashMap<String, String> linkedHashMap1 = dto.getExternalLinks();
        if ( linkedHashMap1 != null ) {
            institutionalPageEntity.externalLinks( new LinkedHashMap<String, String>( linkedHashMap1 ) );
        }
        institutionalPageEntity.buttons( inputButtonDtoListToButtonModelList( dto.getButtons() ) );

        return institutionalPageEntity.build();
    }

    @Override
    public OutputInstitutionalPageDto toDto(InstitutionalPageEntity entity) {
        if ( entity == null ) {
            return null;
        }

        OutputInstitutionalPageDto.OutputInstitutionalPageDtoBuilder outputInstitutionalPageDto = OutputInstitutionalPageDto.builder();

        outputInstitutionalPageDto.copyright( institutionalPageEntityToOutputCopyrightDto( entity ) );
        outputInstitutionalPageDto.repositories( institutionalPageEntityToOutputRepositoriesDto( entity ) );
        outputInstitutionalPageDto.workspaceFolderId( entity.getWorkspaceFolderId() );
        outputInstitutionalPageDto.category( entity.getCategory() );
        outputInstitutionalPageDto.name( entity.getName() );
        outputInstitutionalPageDto.published( entity.isPublished() );
        outputInstitutionalPageDto.toDelete( entity.isToDelete() );
        outputInstitutionalPageDto.moderationStatus( toModerationStatusLabel( entity.getModerationStatus() ) );
        outputInstitutionalPageDto.publicationTime( entity.getPublicationTime() );
        outputInstitutionalPageDto.rejectionMessage( entity.getRejectionMessage() );
        outputInstitutionalPageDto.abstractContent( entity.getAbstractContent() );
        outputInstitutionalPageDto.maintainer( entity.getMaintainer() );
        List<String> list = entity.getTags();
        if ( list != null ) {
            outputInstitutionalPageDto.tags( new ArrayList<String>( list ) );
        }
        List<String> list1 = entity.getLanguages();
        if ( list1 != null ) {
            outputInstitutionalPageDto.languages( new ArrayList<String>( list1 ) );
        }
        outputInstitutionalPageDto.imageUrl( entity.getImageUrl() );
        outputInstitutionalPageDto.userManualUrl( entity.getUserManualUrl() );
        outputInstitutionalPageDto.faqsUrl( entity.getFaqsUrl() );
        outputInstitutionalPageDto.applicationVersion( entity.getApplicationVersion() );
        outputInstitutionalPageDto.applicationType( entity.getApplicationType() );
        outputInstitutionalPageDto.license( entity.getLicense() );
        outputInstitutionalPageDto.supportedOs( entity.getSupportedOs() );
        LinkedHashMap<String, String> linkedHashMap = entity.getAdditionalFields();
        if ( linkedHashMap != null ) {
            outputInstitutionalPageDto.additionalFields( new LinkedHashMap<String, String>( linkedHashMap ) );
        }
        LinkedHashMap<String, String> linkedHashMap1 = entity.getExternalLinks();
        if ( linkedHashMap1 != null ) {
            outputInstitutionalPageDto.externalLinks( new LinkedHashMap<String, String>( linkedHashMap1 ) );
        }
        outputInstitutionalPageDto.buttons( buttonModelListToOutputButtonDtoList( entity.getButtons() ) );
        outputInstitutionalPageDto.updateLockedBy( entity.getUpdateLockedBy() );
        outputInstitutionalPageDto.lastModifiedBy( entity.getLastModifiedBy() );
        outputInstitutionalPageDto.creationTime( entity.getCreationTime() );
        outputInstitutionalPageDto.updateTime( entity.getUpdateTime() );

        return outputInstitutionalPageDto.build();
    }

    @Override
    public OutputRelatedInstitutionalPageDto toRelatedInstitutionalPageDto(InstitutionalPageEntity entity, boolean isMember) {
        if ( entity == null ) {
            return null;
        }

        OutputRelatedInstitutionalPageDto.OutputRelatedInstitutionalPageDtoBuilder outputRelatedInstitutionalPageDto = OutputRelatedInstitutionalPageDto.builder();

        if ( entity != null ) {
            outputRelatedInstitutionalPageDto.institutionalPageId( entity.getId() );
            outputRelatedInstitutionalPageDto.institutionalPageName( entity.getName() );
            outputRelatedInstitutionalPageDto.workspaceFolderId( entity.getWorkspaceFolderId() );
            outputRelatedInstitutionalPageDto.category( entity.getCategory() );
        }
        outputRelatedInstitutionalPageDto.isMember( isMember );

        return outputRelatedInstitutionalPageDto.build();
    }

    @Override
    public void updateEntity(InstitutionalPageEntity entity, InputUpdateInstitutionalPageDto inputUpdateInstitutionalPageDto) {
        if ( inputUpdateInstitutionalPageDto == null ) {
            return;
        }

        entity.setCopyrightText( inputUpdateInstitutionalPageDtoCopyrightText( inputUpdateInstitutionalPageDto ) );
        Integer year = inputUpdateInstitutionalPageDtoCopyrightYear( inputUpdateInstitutionalPageDto );
        if ( year != null ) {
            entity.setCopyrightYear( year );
        }
        entity.setRepoName( inputUpdateInstitutionalPageDtoRepositoriesRepoName( inputUpdateInstitutionalPageDto ) );
        entity.setWebsite( inputUpdateInstitutionalPageDtoRepositoriesWebsite( inputUpdateInstitutionalPageDto ) );
        entity.setName( inputUpdateInstitutionalPageDto.getName() );
        entity.setCategory( inputUpdateInstitutionalPageDto.getCategory() );
        entity.setAbstractContent( inputUpdateInstitutionalPageDto.getAbstractContent() );
        entity.setMaintainer( inputUpdateInstitutionalPageDto.getMaintainer() );
        if ( entity.getTags() != null ) {
            List<String> list = inputUpdateInstitutionalPageDto.getTags();
            if ( list != null ) {
                entity.getTags().clear();
                entity.getTags().addAll( list );
            }
            else {
                entity.setTags( null );
            }
        }
        else {
            List<String> list = inputUpdateInstitutionalPageDto.getTags();
            if ( list != null ) {
                entity.setTags( new ArrayList<String>( list ) );
            }
        }
        if ( entity.getLanguages() != null ) {
            List<String> list1 = inputUpdateInstitutionalPageDto.getLanguages();
            if ( list1 != null ) {
                entity.getLanguages().clear();
                entity.getLanguages().addAll( list1 );
            }
            else {
                entity.setLanguages( null );
            }
        }
        else {
            List<String> list1 = inputUpdateInstitutionalPageDto.getLanguages();
            if ( list1 != null ) {
                entity.setLanguages( new ArrayList<String>( list1 ) );
            }
        }
        entity.setImageUrl( inputUpdateInstitutionalPageDto.getImageUrl() );
        entity.setUserManualUrl( inputUpdateInstitutionalPageDto.getUserManualUrl() );
        entity.setFaqsUrl( inputUpdateInstitutionalPageDto.getFaqsUrl() );
        entity.setApplicationVersion( inputUpdateInstitutionalPageDto.getApplicationVersion() );
        entity.setApplicationType( inputUpdateInstitutionalPageDto.getApplicationType() );
        entity.setLicense( inputUpdateInstitutionalPageDto.getLicense() );
        entity.setSupportedOs( inputUpdateInstitutionalPageDto.getSupportedOs() );
        if ( entity.getAdditionalFields() != null ) {
            LinkedHashMap<String, String> linkedHashMap = inputUpdateInstitutionalPageDto.getAdditionalFields();
            if ( linkedHashMap != null ) {
                entity.getAdditionalFields().clear();
                entity.getAdditionalFields().putAll( linkedHashMap );
            }
            else {
                entity.setAdditionalFields( null );
            }
        }
        else {
            LinkedHashMap<String, String> linkedHashMap = inputUpdateInstitutionalPageDto.getAdditionalFields();
            if ( linkedHashMap != null ) {
                entity.setAdditionalFields( new LinkedHashMap<String, String>( linkedHashMap ) );
            }
        }
        if ( entity.getExternalLinks() != null ) {
            LinkedHashMap<String, String> linkedHashMap1 = inputUpdateInstitutionalPageDto.getExternalLinks();
            if ( linkedHashMap1 != null ) {
                entity.getExternalLinks().clear();
                entity.getExternalLinks().putAll( linkedHashMap1 );
            }
            else {
                entity.setExternalLinks( null );
            }
        }
        else {
            LinkedHashMap<String, String> linkedHashMap1 = inputUpdateInstitutionalPageDto.getExternalLinks();
            if ( linkedHashMap1 != null ) {
                entity.setExternalLinks( new LinkedHashMap<String, String>( linkedHashMap1 ) );
            }
        }
        if ( entity.getButtons() != null ) {
            List<ButtonModel> list2 = inputButtonDtoListToButtonModelList( inputUpdateInstitutionalPageDto.getButtons() );
            if ( list2 != null ) {
                entity.getButtons().clear();
                entity.getButtons().addAll( list2 );
            }
            else {
                entity.setButtons( null );
            }
        }
        else {
            List<ButtonModel> list2 = inputButtonDtoListToButtonModelList( inputUpdateInstitutionalPageDto.getButtons() );
            if ( list2 != null ) {
                entity.setButtons( list2 );
            }
        }
    }

    @Override
    public void updateEntity(InstitutionalPageEntity target, InstitutionalPageEntity src) {
        if ( src == null ) {
            return;
        }

        if ( target.getParagraphs() != null ) {
            List<ParagraphEntity> list = paragraphMapper.cloneParagraphList( src.getParagraphs() );
            if ( list != null ) {
                target.getParagraphs().clear();
                target.getParagraphs().addAll( list );
            }
            else {
                target.setParagraphs( null );
            }
        }
        else {
            List<ParagraphEntity> list = paragraphMapper.cloneParagraphList( src.getParagraphs() );
            if ( list != null ) {
                target.setParagraphs( list );
            }
        }
        target.setName( src.getName() );
        target.setCategory( src.getCategory() );
        target.setPublished( src.isPublished() );
        target.setToDelete( src.isToDelete() );
        target.setAbstractContent( src.getAbstractContent() );
        target.setCopyrightText( src.getCopyrightText() );
        target.setCopyrightYear( src.getCopyrightYear() );
        target.setMaintainer( src.getMaintainer() );
        if ( target.getTags() != null ) {
            List<String> list1 = src.getTags();
            if ( list1 != null ) {
                target.getTags().clear();
                target.getTags().addAll( list1 );
            }
            else {
                target.setTags( null );
            }
        }
        else {
            List<String> list1 = src.getTags();
            if ( list1 != null ) {
                target.setTags( new ArrayList<String>( list1 ) );
            }
        }
        if ( target.getLanguages() != null ) {
            List<String> list2 = src.getLanguages();
            if ( list2 != null ) {
                target.getLanguages().clear();
                target.getLanguages().addAll( list2 );
            }
            else {
                target.setLanguages( null );
            }
        }
        else {
            List<String> list2 = src.getLanguages();
            if ( list2 != null ) {
                target.setLanguages( new ArrayList<String>( list2 ) );
            }
        }
        target.setImageUrl( src.getImageUrl() );
        target.setUserManualUrl( src.getUserManualUrl() );
        target.setFaqsUrl( src.getFaqsUrl() );
        target.setApplicationVersion( src.getApplicationVersion() );
        target.setApplicationType( src.getApplicationType() );
        target.setLicense( src.getLicense() );
        target.setSupportedOs( src.getSupportedOs() );
        target.setRepoName( src.getRepoName() );
        target.setWebsite( src.getWebsite() );
        if ( target.getAdditionalFields() != null ) {
            LinkedHashMap<String, String> linkedHashMap = src.getAdditionalFields();
            if ( linkedHashMap != null ) {
                target.getAdditionalFields().clear();
                target.getAdditionalFields().putAll( linkedHashMap );
            }
            else {
                target.setAdditionalFields( null );
            }
        }
        else {
            LinkedHashMap<String, String> linkedHashMap = src.getAdditionalFields();
            if ( linkedHashMap != null ) {
                target.setAdditionalFields( new LinkedHashMap<String, String>( linkedHashMap ) );
            }
        }
        if ( target.getExternalLinks() != null ) {
            LinkedHashMap<String, String> linkedHashMap1 = src.getExternalLinks();
            if ( linkedHashMap1 != null ) {
                target.getExternalLinks().clear();
                target.getExternalLinks().putAll( linkedHashMap1 );
            }
            else {
                target.setExternalLinks( null );
            }
        }
        else {
            LinkedHashMap<String, String> linkedHashMap1 = src.getExternalLinks();
            if ( linkedHashMap1 != null ) {
                target.setExternalLinks( new LinkedHashMap<String, String>( linkedHashMap1 ) );
            }
        }
        if ( target.getButtons() != null ) {
            List<ButtonModel> list3 = src.getButtons();
            if ( list3 != null ) {
                target.getButtons().clear();
                target.getButtons().addAll( list3 );
            }
            else {
                target.setButtons( null );
            }
        }
        else {
            List<ButtonModel> list3 = src.getButtons();
            if ( list3 != null ) {
                target.setButtons( new ArrayList<ButtonModel>( list3 ) );
            }
        }
        target.setUpdateLockedBy( src.getUpdateLockedBy() );
    }

    @Override
    public InstitutionalPageEntity clone(InstitutionalPageEntity source) {
        if ( source == null ) {
            return null;
        }

        InstitutionalPageEntity.InstitutionalPageEntityBuilder<?, ?> institutionalPageEntity = InstitutionalPageEntity.builder();

        institutionalPageEntity.paragraphs( paragraphMapper.cloneParagraphList( source.getParagraphs() ) );
        institutionalPageEntity.name( source.getName() );
        institutionalPageEntity.parentInstitutionalPageId( source.getParentInstitutionalPageId() );
        List<UUID> list1 = source.getAncestorInstitutionalPageIds();
        if ( list1 != null ) {
            institutionalPageEntity.ancestorInstitutionalPageIds( new ArrayList<UUID>( list1 ) );
        }
        institutionalPageEntity.workspaceFolderId( source.getWorkspaceFolderId() );
        institutionalPageEntity.category( source.getCategory() );
        institutionalPageEntity.published( source.isPublished() );
        institutionalPageEntity.toDelete( source.isToDelete() );
        institutionalPageEntity.moderationStatus( source.getModerationStatus() );
        institutionalPageEntity.publicationTime( source.getPublicationTime() );
        institutionalPageEntity.originalInstitutionalPageId( source.getOriginalInstitutionalPageId() );
        institutionalPageEntity.updatedInstitutionalPageId( source.getUpdatedInstitutionalPageId() );
        institutionalPageEntity.abstractContent( source.getAbstractContent() );
        institutionalPageEntity.copyrightText( source.getCopyrightText() );
        institutionalPageEntity.copyrightYear( source.getCopyrightYear() );
        institutionalPageEntity.maintainer( source.getMaintainer() );
        List<String> list2 = source.getTags();
        if ( list2 != null ) {
            institutionalPageEntity.tags( new ArrayList<String>( list2 ) );
        }
        List<String> list3 = source.getLanguages();
        if ( list3 != null ) {
            institutionalPageEntity.languages( new ArrayList<String>( list3 ) );
        }
        institutionalPageEntity.imageUrl( source.getImageUrl() );
        institutionalPageEntity.userManualUrl( source.getUserManualUrl() );
        institutionalPageEntity.faqsUrl( source.getFaqsUrl() );
        institutionalPageEntity.applicationVersion( source.getApplicationVersion() );
        institutionalPageEntity.applicationType( source.getApplicationType() );
        institutionalPageEntity.license( source.getLicense() );
        institutionalPageEntity.supportedOs( source.getSupportedOs() );
        institutionalPageEntity.repoName( source.getRepoName() );
        institutionalPageEntity.website( source.getWebsite() );
        LinkedHashMap<String, String> linkedHashMap = source.getAdditionalFields();
        if ( linkedHashMap != null ) {
            institutionalPageEntity.additionalFields( new LinkedHashMap<String, String>( linkedHashMap ) );
        }
        LinkedHashMap<String, String> linkedHashMap1 = source.getExternalLinks();
        if ( linkedHashMap1 != null ) {
            institutionalPageEntity.externalLinks( new LinkedHashMap<String, String>( linkedHashMap1 ) );
        }
        List<ButtonModel> list4 = source.getButtons();
        if ( list4 != null ) {
            institutionalPageEntity.buttons( new ArrayList<ButtonModel>( list4 ) );
        }
        institutionalPageEntity.updateLockedBy( source.getUpdateLockedBy() );
        institutionalPageEntity.lastModifiedBy( source.getLastModifiedBy() );
        institutionalPageEntity.creationTime( source.getCreationTime() );
        institutionalPageEntity.updateTime( source.getUpdateTime() );

        return institutionalPageEntity.build();
    }

    @Override
    public SearchForMemberInstitutionalPageModel toModel(InputSearchForMemberInstitutionalPageDto source) {
        if ( source == null ) {
            return null;
        }

        SearchForMemberInstitutionalPageModel.SearchForMemberInstitutionalPageModelBuilder searchForMemberInstitutionalPageModel = SearchForMemberInstitutionalPageModel.builder();

        List<UUID> list = source.getIds();
        if ( list != null ) {
            searchForMemberInstitutionalPageModel.ids( new ArrayList<UUID>( list ) );
        }
        searchForMemberInstitutionalPageModel.includePrivateAndMember( source.getIncludePrivateAndMember() );
        searchForMemberInstitutionalPageModel.includePublishedAndMember( source.getIncludePublishedAndMember() );
        searchForMemberInstitutionalPageModel.includePublishedAndNotMember( source.getIncludePublishedAndNotMember() );
        searchForMemberInstitutionalPageModel.category( source.getCategory() );
        searchForMemberInstitutionalPageModel.rootLevelOnly( source.getRootLevelOnly() );
        searchForMemberInstitutionalPageModel.wpLeaderOnly( source.getWpLeaderOnly() );
        searchForMemberInstitutionalPageModel.searchText( source.getSearchText() );

        return searchForMemberInstitutionalPageModel.build();
    }

    @Override
    public SearchForMemberInstitutionalPageModel toModelForMember(InputSearchModerationInstitutionalPageDto source) {
        if ( source == null ) {
            return null;
        }

        SearchForMemberInstitutionalPageModel.SearchForMemberInstitutionalPageModelBuilder searchForMemberInstitutionalPageModel = SearchForMemberInstitutionalPageModel.builder();

        List<UUID> list = source.getIds();
        if ( list != null ) {
            searchForMemberInstitutionalPageModel.ids( new ArrayList<UUID>( list ) );
        }
        searchForMemberInstitutionalPageModel.category( source.getCategory() );
        searchForMemberInstitutionalPageModel.rootLevelOnly( source.getRootLevelOnly() );
        searchForMemberInstitutionalPageModel.searchText( source.getSearchText() );

        return searchForMemberInstitutionalPageModel.build();
    }

    @Override
    public SearchInstitutionalPageModel toModel(InputSearchPublishedInstitutionalPageDto source) {
        if ( source == null ) {
            return null;
        }

        SearchInstitutionalPageModel.SearchInstitutionalPageModelBuilder searchInstitutionalPageModel = SearchInstitutionalPageModel.builder();

        List<UUID> list = source.getIds();
        if ( list != null ) {
            searchInstitutionalPageModel.ids( new ArrayList<UUID>( list ) );
        }
        searchInstitutionalPageModel.category( source.getCategory() );
        searchInstitutionalPageModel.rootLevelOnly( source.getRootLevelOnly() );
        searchInstitutionalPageModel.searchText( source.getSearchText() );

        return searchInstitutionalPageModel.build();
    }

    @Override
    public SearchInstitutionalPageModel toModel(InputSearchModerationInstitutionalPageDto source) {
        if ( source == null ) {
            return null;
        }

        SearchInstitutionalPageModel.SearchInstitutionalPageModelBuilder searchInstitutionalPageModel = SearchInstitutionalPageModel.builder();

        List<UUID> list = source.getIds();
        if ( list != null ) {
            searchInstitutionalPageModel.ids( new ArrayList<UUID>( list ) );
        }
        searchInstitutionalPageModel.published( source.getPublished() );
        searchInstitutionalPageModel.category( source.getCategory() );
        searchInstitutionalPageModel.rootLevelOnly( source.getRootLevelOnly() );
        searchInstitutionalPageModel.searchText( source.getSearchText() );

        return searchInstitutionalPageModel.build();
    }

    @Override
    public ModerationStatus toModerationStatusEnum(InstitutionalPageView source) {
        if ( source == null ) {
            return null;
        }

        ModerationStatus moderationStatus;

        switch ( source ) {
            case APPROVED: moderationStatus = ModerationStatus.APPROVED;
            break;
            case PENDING: moderationStatus = ModerationStatus.PENDING;
            break;
            case REJECTED: moderationStatus = ModerationStatus.REJECTED;
            break;
            case DRAFT: moderationStatus = ModerationStatus.DRAFT;
            break;
            case LATEST: throw new IllegalArgumentException( "Unexpected enum constant: " + source );
            case ORIGINAL: throw new IllegalArgumentException( "Unexpected enum constant: " + source );
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + source );
        }

        return moderationStatus;
    }

    private String dtoCopyrightText(InputCreateInstitutionalPageDto inputCreateInstitutionalPageDto) {
        InputCopyrightDto copyright = inputCreateInstitutionalPageDto.getCopyright();
        if ( copyright == null ) {
            return null;
        }
        return copyright.getText();
    }

    private Integer dtoCopyrightYear(InputCreateInstitutionalPageDto inputCreateInstitutionalPageDto) {
        InputCopyrightDto copyright = inputCreateInstitutionalPageDto.getCopyright();
        if ( copyright == null ) {
            return null;
        }
        return copyright.getYear();
    }

    private String dtoRepositoriesRepoName(InputCreateInstitutionalPageDto inputCreateInstitutionalPageDto) {
        InputRepositoriesDto repositories = inputCreateInstitutionalPageDto.getRepositories();
        if ( repositories == null ) {
            return null;
        }
        return repositories.getRepoName();
    }

    private String dtoRepositoriesWebsite(InputCreateInstitutionalPageDto inputCreateInstitutionalPageDto) {
        InputRepositoriesDto repositories = inputCreateInstitutionalPageDto.getRepositories();
        if ( repositories == null ) {
            return null;
        }
        return repositories.getWebsite();
    }

    protected ButtonModel inputButtonDtoToButtonModel(InputButtonDto inputButtonDto) {
        if ( inputButtonDto == null ) {
            return null;
        }

        ButtonModel.ButtonModelBuilder buttonModel = ButtonModel.builder();

        buttonModel.label( inputButtonDto.getLabel() );
        buttonModel.link( inputButtonDto.getLink() );
        buttonModel.buttonType( inputButtonDto.getButtonType() );
        buttonModel.iconCssClass( inputButtonDto.getIconCssClass() );

        return buttonModel.build();
    }

    protected List<ButtonModel> inputButtonDtoListToButtonModelList(List<InputButtonDto> list) {
        if ( list == null ) {
            return null;
        }

        List<ButtonModel> list1 = new ArrayList<ButtonModel>( list.size() );
        for ( InputButtonDto inputButtonDto : list ) {
            list1.add( inputButtonDtoToButtonModel( inputButtonDto ) );
        }

        return list1;
    }

    protected OutputCopyrightDto institutionalPageEntityToOutputCopyrightDto(InstitutionalPageEntity institutionalPageEntity) {
        if ( institutionalPageEntity == null ) {
            return null;
        }

        OutputCopyrightDto.OutputCopyrightDtoBuilder outputCopyrightDto = OutputCopyrightDto.builder();

        outputCopyrightDto.text( institutionalPageEntity.getCopyrightText() );
        outputCopyrightDto.year( institutionalPageEntity.getCopyrightYear() );

        return outputCopyrightDto.build();
    }

    protected OutputRepositoriesDto institutionalPageEntityToOutputRepositoriesDto(InstitutionalPageEntity institutionalPageEntity) {
        if ( institutionalPageEntity == null ) {
            return null;
        }

        OutputRepositoriesDto.OutputRepositoriesDtoBuilder outputRepositoriesDto = OutputRepositoriesDto.builder();

        outputRepositoriesDto.repoName( institutionalPageEntity.getRepoName() );
        outputRepositoriesDto.website( institutionalPageEntity.getWebsite() );

        return outputRepositoriesDto.build();
    }

    protected OutputButtonDto buttonModelToOutputButtonDto(ButtonModel buttonModel) {
        if ( buttonModel == null ) {
            return null;
        }

        OutputButtonDto.OutputButtonDtoBuilder outputButtonDto = OutputButtonDto.builder();

        outputButtonDto.label( buttonModel.getLabel() );
        outputButtonDto.link( buttonModel.getLink() );
        outputButtonDto.buttonType( buttonModel.getButtonType() );
        outputButtonDto.iconCssClass( buttonModel.getIconCssClass() );

        return outputButtonDto.build();
    }

    protected List<OutputButtonDto> buttonModelListToOutputButtonDtoList(List<ButtonModel> list) {
        if ( list == null ) {
            return null;
        }

        List<OutputButtonDto> list1 = new ArrayList<OutputButtonDto>( list.size() );
        for ( ButtonModel buttonModel : list ) {
            list1.add( buttonModelToOutputButtonDto( buttonModel ) );
        }

        return list1;
    }

    private String inputUpdateInstitutionalPageDtoCopyrightText(InputUpdateInstitutionalPageDto inputUpdateInstitutionalPageDto) {
        InputCopyrightDto copyright = inputUpdateInstitutionalPageDto.getCopyright();
        if ( copyright == null ) {
            return null;
        }
        return copyright.getText();
    }

    private Integer inputUpdateInstitutionalPageDtoCopyrightYear(InputUpdateInstitutionalPageDto inputUpdateInstitutionalPageDto) {
        InputCopyrightDto copyright = inputUpdateInstitutionalPageDto.getCopyright();
        if ( copyright == null ) {
            return null;
        }
        return copyright.getYear();
    }

    private String inputUpdateInstitutionalPageDtoRepositoriesRepoName(InputUpdateInstitutionalPageDto inputUpdateInstitutionalPageDto) {
        InputRepositoriesDto repositories = inputUpdateInstitutionalPageDto.getRepositories();
        if ( repositories == null ) {
            return null;
        }
        return repositories.getRepoName();
    }

    private String inputUpdateInstitutionalPageDtoRepositoriesWebsite(InputUpdateInstitutionalPageDto inputUpdateInstitutionalPageDto) {
        InputRepositoriesDto repositories = inputUpdateInstitutionalPageDto.getRepositories();
        if ( repositories == null ) {
            return null;
        }
        return repositories.getWebsite();
    }
}
