package com.finconsgroup.itserr.marketplace.institutionalpage.dm.component;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.ArchivedInstitutionalPageEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.ArchivedMemberRequestEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.InstitutionalPageEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.MemberRequestEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.MemberRequestStatus;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.mapper.ArchivedEntityMapper;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.repository.ArchivedInstitutionalPageRepository;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.repository.ArchivedMemberRequestRepository;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * Helper component responsible for persisting archived copies of entities.
 * It maps active entities to their archived counterparts and stores them in their respective repositories.
 */
@Component
@RequiredArgsConstructor
public class ArchiveHelper {

    private final ArchivedInstitutionalPageRepository archivedInstitutionalPageRepository;
    private final ArchivedMemberRequestRepository archivedMemberRequestRepository;
    private final ArchivedEntityMapper archivedEntityMapper;
    private final EntityBuilder entityBuilder;

    public void persistArchivedCopy(
            InstitutionalPageEntity institutionalPageEntity
    ) {
        // map institutionalPageEntity to archivedInstitutionalPageEntity (ID included)
        ArchivedInstitutionalPageEntity archivedInstitutionalPageEntity = entityBuilder
                .buildArchivedEntity(institutionalPageEntity);
        archivedInstitutionalPageRepository.saveAndFlush(archivedInstitutionalPageEntity);
    }

    public void persistArchivedCopy(
            MemberRequestEntity requestEntity,
            MemberRequestStatus requestStatus,
            String message
    ) {
        persistArchivedCopy(List.of(requestEntity), requestStatus, message);
    }

    public void persistArchivedCopy(
            List<MemberRequestEntity> requestEntities,
            MemberRequestStatus requestStatus,
            String message
    ) {
        // map requestEntities to archivedRequestEntities (ID included)
        List<ArchivedMemberRequestEntity> archivedRequestEntities;
        if (StringUtils.isNotBlank(message)) {
            archivedRequestEntities = archivedEntityMapper.toArchiveEntityList(requestEntities, requestStatus, message);
        } else {
            archivedRequestEntities = archivedEntityMapper.toArchiveEntityList(requestEntities, requestStatus);
        }
        archivedMemberRequestRepository.saveAllAndFlush(archivedRequestEntities);
    }

}
