package com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;

import static com.finconsgroup.itserr.marketplace.institutionalpage.dm.util.Constants.MAX_LONG_TEXT_LENGTH;
import static com.finconsgroup.itserr.marketplace.institutionalpage.dm.util.Constants.MAX_MEDIUM_TEXT_LENGTH;
import static com.finconsgroup.itserr.marketplace.institutionalpage.dm.util.Constants.MAX_URL_LENGTH;
import static com.finconsgroup.itserr.marketplace.institutionalpage.dm.util.Constants.VALIDATION_ERROR_FIELD_LENGTH;
import static com.finconsgroup.itserr.marketplace.institutionalpage.dm.util.Constants.VALIDATION_ERROR_REQUIRED_FIELD;

/**
 * Input Dto of a paragraph related to the institutional page.
 */
@Schema(name = "InputParagraphDto", description = "Input DTO of a paragraph related to the institutional page")
@Data
@Builder
@AllArgsConstructor
// TODO currently not mandatory from FE - @ValidInputDto
public class InputParagraphDto {

    @Schema(description = "The title of the paragraph", example = "Outcomes")
    @NotBlank(message = VALIDATION_ERROR_REQUIRED_FIELD)
    @Size(max = MAX_MEDIUM_TEXT_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String title;

    @Schema(description = "The content of the paragraph", example = "A shared library of reusable software components")
    @Size(max = MAX_LONG_TEXT_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String content;

    @Schema(description = "The image url of the paragraph", example = "https://picsum.photos/200")
    @Size(max = MAX_URL_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String imageUrl;

    @Schema(description = "The resource url of the paragraph", example = "https://www.example.com/")
    @Size(max = MAX_URL_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String resourceUrl;

    @Schema(description = "list of labels related to the paragraph", example = "[\"god\",\"marriage\"]")
    private List<
            @NotBlank(message = VALIDATION_ERROR_REQUIRED_FIELD) @Size(max = MAX_MEDIUM_TEXT_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH) String
            > labels;

}
