package com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;

import java.util.Set;
import java.util.UUID;

public class CannotRemoveMaintainerException extends WP2BusinessException {

    public static final String EXCEPTION_MESSAGE =
            "User with id '%s' cannot be removed because they are the maintainer of the Institutional Pages with ids '%s'";

    public CannotRemoveMaintainerException(
            UUID userId,
            Set<UUID> institutionalPageIds
    ) {
        super(EXCEPTION_MESSAGE.formatted(userId, institutionalPageIds));
    }
}
