package com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;

import java.util.List;
import java.util.UUID;

public class UsersAlreadyMemberException extends WP2BusinessException {

    public static final String EXCEPTION_MESSAGE =
            "Institutional page with id '%s' already has members with ids: '%s'";

    public UsersAlreadyMemberException(
            UUID institutionalPageId,
            List<UUID> userIds
    ) {
        super(EXCEPTION_MESSAGE.formatted(institutionalPageId, userIds));
    }

}
