package com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

/**
 * Output DTO of repository links for the institutional page.
 */
@Schema(
        name = "OutputRepositoriesDto",
        description = "Output DTO of repository links for the institutional page"
)
@Data
@Builder
@AllArgsConstructor
public class OutputRepositoriesDto {

    @Schema(description = "URL of the source repository", example = "https://github.com/example/wp3-tres")
    private String repoName;

    @Schema(description = "URL of the website", example = "https://www.wp3tres.com")
    private String website;

}
