/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.api.ParagraphApi;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputParagraphDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.service.ParagraphService;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ParagraphController
implements ParagraphApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ParagraphController.class);
    private final ParagraphService paragraphService;

    public OutputInstitutionalPageDto addParagraph(UUID institutionalPageId, Integer position, InputParagraphDto inputParagraphDto) {
        log.debug("POST /api/v1/dm/institutional-page/institutional-pages/{}/paragraphs, position {}, inputParagraphDto: {}", new Object[]{institutionalPageId, position, inputParagraphDto});
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.paragraphService.addParagraph(userId, institutionalPageId, position, inputParagraphDto);
    }

    public OutputInstitutionalPageDto updateParagraph(UUID institutionalPageId, UUID paragraphId, InputParagraphDto inputParagraphDto) {
        log.debug("PUT /api/v1/dm/institutional-page/institutional-pages/{}/paragraphs/{}, inputParagraphDto: {}", new Object[]{institutionalPageId, paragraphId, inputParagraphDto});
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.paragraphService.updateParagraph(userId, institutionalPageId, paragraphId, inputParagraphDto);
    }

    public OutputInstitutionalPageDto removeParagraph(UUID institutionalPageId, UUID paragraphId) {
        log.debug("DELETE /api/v1/dm/institutional-page/institutional-pages/{}/paragraphs/{}", (Object)institutionalPageId, (Object)paragraphId);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.paragraphService.removeParagraph(userId, institutionalPageId, paragraphId);
    }

    @Generated
    public ParagraphController(ParagraphService paragraphService) {
        this.paragraphService = paragraphService;
    }
}

