package com.finconsgroup.itserr.marketplace.institutionalpage.dm.converter;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.ModerationStatus;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class ModerationStatusJsonConverter
        implements Converter<String, ModerationStatus> {

    @Override
    public ModerationStatus convert(String source) {
        if (source == null || source.isBlank()) {
            throw new IllegalArgumentException("moderationStatus must not be blank");
        }
        return ModerationStatus.ofLabel(source);
    }
}
