/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.service.impl;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.component.ArchiveHelper;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.component.DtoBuilder;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.component.EntityBuilder;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.component.InstitutionalPageHelper;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.component.MemberHelper;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.component.MemberRequestHelper;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputInviteMembersDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputPatchIPInvitationRequestDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputPatchIPJoinRequestDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputPatchMembershipDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputRemoveMembershipDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputSubmitJoinRequestDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputMembersInHierarchyDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputPendingMemberRequestDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputPendingMemberRequestsDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.InstitutionalPageEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.MemberEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.MemberRequestEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.MemberRequestStatus;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.MemberRequestType;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception.MembersAlreadyWpLeaderInHierarchyException;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception.NotInstitutionalPageWPLeaderException;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception.TargetUserNotMemberException;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception.UserIsTheOnlyWpLeaderException;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.mapper.MemberRequestMapper;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.model.MembersInHierarchyModel;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.repository.MemberRequestRepository;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.service.MemberService;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultMemberService
implements MemberService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMemberService.class);
    private final InstitutionalPageHelper institutionalPageHelper;
    private final MemberHelper memberHelper;
    private final MemberRequestHelper memberRequestHelper;
    private final ArchiveHelper archiveHelper;
    private final MemberRequestRepository memberRequestRepository;
    private final MemberRequestMapper memberRequestMapper;
    private final EntityBuilder memberBuilder;
    private final DtoBuilder dtoBuilder;

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Boolean isAdmin() {
        return this.memberHelper.isAdmin();
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public OutputPendingMemberRequestsDto findPendingMemberRequestsForInstitutionalPage(@NonNull UUID userId, @NonNull UUID institutionalPageId) {
        this.memberHelper.verifyAdminOrWpLeaderOrThrow(userId, institutionalPageId);
        InstitutionalPageEntity institutionalPageEntity = this.institutionalPageHelper.retrieveApprovedById(institutionalPageId);
        boolean isRoot = this.institutionalPageHelper.isRoot(institutionalPageEntity);
        LinkedList<InstitutionalPageEntity> institutionalPagesInHierarchy = new LinkedList<InstitutionalPageEntity>();
        if (isRoot) {
            institutionalPagesInHierarchy.addAll(this.institutionalPageHelper.retrieveAllOriginalInHierarchyByRootId(Pageable.unpaged(), institutionalPageId).getContent());
        } else {
            institutionalPagesInHierarchy.add(institutionalPageEntity);
        }
        Map institutionPageIdToDtoMap = this.dtoBuilder.mapEntitiesToDtos(userId, institutionalPagesInHierarchy).stream().collect(Collectors.toMap(OutputInstitutionalPageDto::getId, Function.identity()));
        List memberRequests = this.memberRequestRepository.findAllByInstitutionalPageIdIn(institutionPageIdToDtoMap.keySet());
        LinkedList<OutputPendingMemberRequestDto> invitations = new LinkedList<OutputPendingMemberRequestDto>();
        LinkedList<OutputPendingMemberRequestDto> joinRequests = new LinkedList<OutputPendingMemberRequestDto>();
        for (MemberRequestEntity memberRequest : memberRequests) {
            OutputInstitutionalPageDto outputInstitutionalPageDto = (OutputInstitutionalPageDto)institutionPageIdToDtoMap.get(memberRequest.getInstitutionalPageId());
            OutputPendingMemberRequestDto outputPendingRequest = this.memberRequestMapper.toOutputPendingRequestDto(memberRequest, outputInstitutionalPageDto);
            if (memberRequest.getRequestType().equals((Object)MemberRequestType.INVITATION)) {
                invitations.add(outputPendingRequest);
                continue;
            }
            if (!memberRequest.getRequestType().equals((Object)MemberRequestType.JOIN_REQUEST)) continue;
            joinRequests.add(outputPendingRequest);
        }
        OutputPendingMemberRequestsDto outputPendingMemberRequestsDto = OutputPendingMemberRequestsDto.builder().invitations(invitations).joinRequests(joinRequests).build();
        return outputPendingMemberRequestsDto;
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public OutputPendingMemberRequestsDto findPendingMemberRequestsForUser(@NonNull UUID userId) {
        List memberRequests = this.memberRequestRepository.findAllByUserId(userId);
        List<UUID> institutionalPageIds = memberRequests.stream().map(MemberRequestEntity::getInstitutionalPageId).toList();
        List institutionalPageEntities = this.institutionalPageHelper.retrieveAllApprovedByIds(institutionalPageIds);
        Map institutionPageIdToDtoMap = this.dtoBuilder.mapEntitiesToDtos(userId, institutionalPageEntities).stream().collect(Collectors.toMap(OutputInstitutionalPageDto::getId, Function.identity()));
        LinkedList<OutputPendingMemberRequestDto> invitations = new LinkedList<OutputPendingMemberRequestDto>();
        LinkedList<OutputPendingMemberRequestDto> joinRequests = new LinkedList<OutputPendingMemberRequestDto>();
        for (MemberRequestEntity memberRequest : memberRequests) {
            UUID institutionalPageId = memberRequest.getInstitutionalPageId();
            OutputInstitutionalPageDto outputInstitutionalPageDto = (OutputInstitutionalPageDto)institutionPageIdToDtoMap.get(institutionalPageId);
            OutputPendingMemberRequestDto outputPendingRequest = this.memberRequestMapper.toOutputPendingRequestDto(memberRequest, outputInstitutionalPageDto);
            if (memberRequest.getRequestType().equals((Object)MemberRequestType.INVITATION)) {
                invitations.add(outputPendingRequest);
                continue;
            }
            if (!memberRequest.getRequestType().equals((Object)MemberRequestType.JOIN_REQUEST)) continue;
            joinRequests.add(outputPendingRequest);
        }
        OutputPendingMemberRequestsDto outputPendingMemberRequestsDto = OutputPendingMemberRequestsDto.builder().invitations(invitations).joinRequests(joinRequests).build();
        return outputPendingMemberRequestsDto;
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputPendingMemberRequestsDto inviteMembers(@NonNull UUID userId, @NonNull UUID institutionalPageId, @NonNull InputInviteMembersDto inputInviteMembersDto) {
        this.memberHelper.verifyWpLeaderOrThrow(userId, institutionalPageId);
        this.memberHelper.verifyNotAlreadyMembersOrThrow(inputInviteMembersDto.getUserIds(), institutionalPageId);
        this.memberRequestHelper.verifyInvitationsNotAlreadyExistOrThrow(institutionalPageId, inputInviteMembersDto.getUserIds());
        boolean wpLeader = inputInviteMembersDto.getWpLeader();
        String message = inputInviteMembersDto.getMessage();
        List<MemberRequestEntity> pendingInvitations = inputInviteMembersDto.getUserIds().stream().map(invitedUserId -> this.memberBuilder.buildInvitation(institutionalPageId, invitedUserId, wpLeader, message)).toList();
        this.memberRequestRepository.saveAllAndFlush(pendingInvitations);
        return this.findPendingMemberRequestsForInstitutionalPage(userId, institutionalPageId);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputPendingMemberRequestsDto cancelInvitation(@NonNull UUID userId, @NonNull UUID institutionalPageId, @NonNull UUID invitedUserId) {
        this.memberHelper.verifyWpLeaderOrThrow(userId, institutionalPageId);
        MemberRequestEntity pendingInvitation = this.memberRequestHelper.retrieveInvitationOrThrow(institutionalPageId, invitedUserId);
        this.archiveHelper.persistArchivedCopy(pendingInvitation, MemberRequestStatus.CANCELLED, null);
        this.memberRequestRepository.delete((Object)pendingInvitation);
        return this.findPendingMemberRequestsForInstitutionalPage(userId, institutionalPageId);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputPendingMemberRequestsDto acceptOrRejectInvitation(@NonNull UUID userId, @NonNull UUID institutionalPageId, @NonNull InputPatchIPInvitationRequestDto inputPatchIPInvitationRequestDto) {
        MemberRequestEntity invitation = this.memberRequestHelper.retrieveInvitationOrThrow(institutionalPageId, userId);
        if (inputPatchIPInvitationRequestDto.getApproved().booleanValue()) {
            InstitutionalPageEntity institutionalPage = this.institutionalPageHelper.retrieveApprovedById(institutionalPageId);
            if (invitation.isWpLeader()) {
                InstitutionalPageEntity rootInstitutionalPage = this.institutionalPageHelper.retrieveRootInstitutionalPage(institutionalPage);
                Optional<MemberEntity> existingRootMember = rootInstitutionalPage.getMembers().stream().filter(memberEntity -> userId.equals(memberEntity.getMemberId())).findFirst();
                if (existingRootMember.isPresent()) {
                    existingRootMember.get().setWpLead(true);
                } else {
                    MemberEntity wpLeader = this.memberBuilder.buildWPLeader(userId, rootInstitutionalPage);
                    rootInstitutionalPage.getMembers().add(wpLeader);
                }
                this.institutionalPageHelper.save(userId, rootInstitutionalPage);
                this.memberHelper.deleteRegularMembersFromDescendants(userId, rootInstitutionalPage.getId(), List.of(userId));
                String message = inputPatchIPInvitationRequestDto.getMessage();
                this.archiveHelper.persistArchivedCopy(invitation, MemberRequestStatus.APPROVED, message);
                this.memberRequestRepository.delete((Object)invitation);
                String cancelMessage = "user added as wpLeader";
                List memberRequests = this.memberRequestRepository.findAllRequestsFromIpAndDescendants(rootInstitutionalPage.getId(), List.of(userId));
                this.archiveHelper.persistArchivedCopy(memberRequests, MemberRequestStatus.CANCELLED, cancelMessage);
                this.memberRequestRepository.deleteAll((Iterable)memberRequests);
            } else {
                MemberEntity member = this.memberBuilder.buildRegularMember(userId, institutionalPageId);
                institutionalPage.getMembers().add(member);
                this.institutionalPageHelper.save(userId, institutionalPage);
                String message = inputPatchIPInvitationRequestDto.getMessage();
                this.archiveHelper.persistArchivedCopy(invitation, MemberRequestStatus.APPROVED, message);
                this.memberRequestRepository.delete((Object)invitation);
                this.memberRequestHelper.retrieveJoinRequest(institutionalPageId, userId).ifPresent(joinRequest -> {
                    String cancelMessage = "accepted invitation";
                    this.archiveHelper.persistArchivedCopy(joinRequest, MemberRequestStatus.CANCELLED, cancelMessage);
                    this.memberRequestRepository.delete(joinRequest);
                });
            }
        } else {
            String message = inputPatchIPInvitationRequestDto.getMessage();
            this.archiveHelper.persistArchivedCopy(invitation, MemberRequestStatus.REJECTED, message);
            this.memberRequestRepository.delete((Object)invitation);
        }
        return this.findPendingMemberRequestsForUser(userId);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputInstitutionalPageDto patchMembershipOfUsersForInstitutionalPage(@NonNull UUID userId, @NonNull UUID institutionalPageId, @NonNull InputPatchMembershipDto inputPatchMembershipDto) {
        UUID targetUserId = inputPatchMembershipDto.getUserId();
        boolean promoteToWpLeader = inputPatchMembershipDto.getWpLeader();
        this.memberHelper.verifyWpLeaderOrThrow(userId, institutionalPageId);
        InstitutionalPageEntity institutionalPage = this.institutionalPageHelper.retrieveApprovedForMemberById(userId, institutionalPageId);
        if (!this.memberHelper.isMember(targetUserId, institutionalPage)) {
            throw new TargetUserNotMemberException(targetUserId, institutionalPageId);
        }
        InstitutionalPageEntity rootInstitutionalPage = this.institutionalPageHelper.retrieveRootForMemberById(userId, institutionalPageId);
        if (rootInstitutionalPage.getMembers() == null) {
            rootInstitutionalPage.setMembers(new LinkedList());
        }
        MemberEntity member = rootInstitutionalPage.getMembers().stream().filter(memberEntity -> memberEntity.getMemberId().equals(targetUserId)).findFirst().orElse(null);
        if (promoteToWpLeader) {
            if (member != null) {
                if (member.isWpLead()) {
                    throw new MembersAlreadyWpLeaderInHierarchyException(institutionalPageId, Set.of(targetUserId));
                }
                member.setWpLead(true);
            } else {
                MemberEntity wpLeader = this.memberBuilder.buildWPLeader(targetUserId, rootInstitutionalPage);
                rootInstitutionalPage.getMembers().add(wpLeader);
            }
            this.memberHelper.deleteRegularMembersFromDescendants(userId, rootInstitutionalPage.getId(), List.of(targetUserId));
            String message = "user promoted to wpLeader";
            List memberRequests = this.memberRequestRepository.findAllRequestsFromIpAndDescendants(rootInstitutionalPage.getId(), List.of(targetUserId));
            this.archiveHelper.persistArchivedCopy(memberRequests, MemberRequestStatus.CANCELLED, message);
            this.memberRequestRepository.deleteAll((Iterable)memberRequests);
        } else if (member != null && member.isWpLead()) {
            member.setWpLead(false);
        } else {
            throw new NotInstitutionalPageWPLeaderException(institutionalPageId, targetUserId);
        }
        InstitutionalPageEntity savedInstitutionalPage = this.institutionalPageHelper.save(userId, rootInstitutionalPage);
        OutputInstitutionalPageDto outputInstitutionalPageDto = this.dtoBuilder.mapEntityToDto(userId, savedInstitutionalPage);
        return outputInstitutionalPageDto;
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputInstitutionalPageDto removeMembershipOfUsersForInstitutionalPage(@NonNull UUID userId, @NonNull UUID institutionalPageId, @NonNull InputRemoveMembershipDto inputRemoveMembershipDto) {
        OutputInstitutionalPageDto outputInstitutionalPageDto;
        UUID targetUserId = inputRemoveMembershipDto.getUserId();
        if (userId.equals(targetUserId)) {
            this.memberHelper.verifyMemberOrThrow(userId, institutionalPageId);
        } else {
            this.memberHelper.verifyWpLeaderOrThrow(userId, institutionalPageId);
        }
        InstitutionalPageEntity institutionalPage = this.institutionalPageHelper.retrieveApprovedForMemberById(userId, institutionalPageId);
        if (this.memberHelper.isWpLeader(targetUserId, institutionalPage)) {
            List<UUID> wpLeaderIds;
            InstitutionalPageEntity rootInstitutionalPage = this.institutionalPageHelper.retrieveRootForMemberById(userId, institutionalPageId);
            if (userId.equals(targetUserId) && (wpLeaderIds = rootInstitutionalPage.getMembers().stream().filter(MemberEntity::isWpLead).map(MemberEntity::getMemberId).toList()).size() == 1 && wpLeaderIds.getFirst().equals(userId)) {
                throw new UserIsTheOnlyWpLeaderException(userId, institutionalPageId);
            }
            rootInstitutionalPage.getMembers().removeIf(memberEntity -> memberEntity.getMemberId().equals(targetUserId));
            this.institutionalPageHelper.save(userId, rootInstitutionalPage);
            outputInstitutionalPageDto = this.dtoBuilder.mapEntityToDto(userId, institutionalPage);
        } else if (this.memberHelper.isRegularMember(targetUserId, institutionalPage)) {
            institutionalPage.getMembers().removeIf(memberEntity -> memberEntity.getMemberId().equals(targetUserId));
            InstitutionalPageEntity savedInstitutionalPage = this.institutionalPageHelper.save(userId, institutionalPage);
            outputInstitutionalPageDto = this.dtoBuilder.mapEntityToDto(userId, savedInstitutionalPage);
        } else {
            throw new TargetUserNotMemberException(targetUserId, institutionalPageId);
        }
        return outputInstitutionalPageDto;
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputPendingMemberRequestsDto submitJoinRequest(@NonNull UUID userId, @NonNull UUID institutionalPageId, @NonNull InputSubmitJoinRequestDto inputSubmitJoinRequestDto) {
        this.memberHelper.verifyNotAlreadyMemberOrThrow(userId, institutionalPageId);
        this.institutionalPageHelper.retrievePublishedById(institutionalPageId);
        this.memberRequestHelper.verifyJoinRequestsNotAlreadyExistOrThrow(institutionalPageId, List.of(userId));
        String message = inputSubmitJoinRequestDto.getMessage();
        MemberRequestEntity joinRequest = this.memberBuilder.buildJoinRequest(institutionalPageId, userId, message);
        this.memberRequestRepository.saveAndFlush((Object)joinRequest);
        return this.findPendingMemberRequestsForUser(userId);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputPendingMemberRequestsDto cancelJoinRequest(@NonNull UUID userId, @NonNull UUID institutionalPageId) {
        MemberRequestEntity joinRequest = this.memberRequestHelper.retrieveJoinRequestOrThrow(institutionalPageId, userId);
        this.archiveHelper.persistArchivedCopy(joinRequest, MemberRequestStatus.CANCELLED, null);
        this.memberRequestRepository.delete((Object)joinRequest);
        return this.findPendingMemberRequestsForUser(userId);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputPendingMemberRequestsDto acceptOrRejectJoinRequests(@NonNull UUID userId, @NonNull UUID institutionalPageId, @NonNull InputPatchIPJoinRequestDto inputPatchIPJoinRequestDto) {
        String message;
        this.memberHelper.verifyWpLeaderOrThrow(userId, institutionalPageId);
        List joinRequests = this.memberRequestHelper.retrieveAllJoinRequestsByUserIdsOrThrow(institutionalPageId, inputPatchIPJoinRequestDto.getUserIds());
        if (inputPatchIPJoinRequestDto.getApproved().booleanValue()) {
            InstitutionalPageEntity institutionalPageEntity = this.institutionalPageHelper.retrieveOriginalForMemberById(userId, institutionalPageId);
            if (institutionalPageEntity.getMembers() == null) {
                institutionalPageEntity.setMembers(new LinkedList());
            }
            joinRequests.stream().map(joinRequest -> this.memberBuilder.buildRegularMember(joinRequest.getUserId(), institutionalPageId)).forEach(member -> institutionalPageEntity.getMembers().add(member));
            this.institutionalPageHelper.save(userId, institutionalPageEntity);
            message = "accepted join request";
            List invitations = this.memberRequestHelper.retrieveInvitations(institutionalPageId, inputPatchIPJoinRequestDto.getUserIds());
            this.archiveHelper.persistArchivedCopy(invitations, MemberRequestStatus.CANCELLED, message);
            this.memberRequestRepository.deleteAll((Iterable)invitations);
        }
        MemberRequestStatus memberRequestStatus = inputPatchIPJoinRequestDto.getApproved() != false ? MemberRequestStatus.APPROVED : MemberRequestStatus.REJECTED;
        message = inputPatchIPJoinRequestDto.getMessage();
        this.archiveHelper.persistArchivedCopy(joinRequests, memberRequestStatus, message);
        this.memberRequestRepository.deleteAll((Iterable)joinRequests);
        return this.findPendingMemberRequestsForInstitutionalPage(userId, institutionalPageId);
    }

    @NonNull
    public Page<OutputMembersInHierarchyDto> findAllUsersInHierarchy(@NonNull UUID userId, @NonNull Pageable pageable, @NonNull UUID rootInstitutionalPageId) {
        this.memberHelper.verifyWpLeaderOrThrow(userId, rootInstitutionalPageId);
        List institutionalPagesInHierarchy = this.institutionalPageHelper.retrieveAllOriginalInHierarchyByRootId(Pageable.unpaged(), rootInstitutionalPageId).getContent();
        Map institutionPageIdToDtoMap = this.dtoBuilder.mapEntitiesToDtos(userId, institutionalPagesInHierarchy).stream().collect(Collectors.toMap(OutputInstitutionalPageDto::getId, Function.identity()));
        MembersInHierarchyModel membersInHierarchy = this.memberHelper.findUsersByRootId(pageable, rootInstitutionalPageId);
        List<OutputMembersInHierarchyDto> OutputMembersInHierarchyDtos = membersInHierarchy.getMembers().stream().collect(Collectors.groupingBy(MemberEntity::getMemberId)).entrySet().stream().map(entry -> DtoBuilder.toMembersInHierarchyDto((UUID)rootInstitutionalPageId, (Map.Entry)entry, (Map)institutionPageIdToDtoMap)).toList();
        return new PageImpl(OutputMembersInHierarchyDtos, membersInHierarchy.getPageable(), membersInHierarchy.getTotalElements());
    }

    @Generated
    public DefaultMemberService(InstitutionalPageHelper institutionalPageHelper, MemberHelper memberHelper, MemberRequestHelper memberRequestHelper, ArchiveHelper archiveHelper, MemberRequestRepository memberRequestRepository, MemberRequestMapper memberRequestMapper, EntityBuilder memberBuilder, DtoBuilder dtoBuilder) {
        this.institutionalPageHelper = institutionalPageHelper;
        this.memberHelper = memberHelper;
        this.memberRequestHelper = memberRequestHelper;
        this.archiveHelper = archiveHelper;
        this.memberRequestRepository = memberRequestRepository;
        this.memberRequestMapper = memberRequestMapper;
        this.memberBuilder = memberBuilder;
        this.dtoBuilder = dtoBuilder;
    }
}

