/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.component;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.component.EntityBuilder;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.component.InstitutionalPageHelper;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.InstitutionalPageEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.ModerationStatus;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception.InvalidModerationStatusException;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception.UnexpectedModerationStatusException;
import java.time.Instant;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InstitutionalPageModerationHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstitutionalPageModerationHandler.class);
    private final InstitutionalPageHelper institutionalPageHelper;
    private final EntityBuilder entityBuilder;

    public InstitutionalPageEntity create(InstitutionalPageEntity institutionalPage) {
        if (institutionalPage.getId() == null && institutionalPage.getModerationStatus() == null) {
            institutionalPage.setModerationStatus(ModerationStatus.PENDING);
            return institutionalPage;
        }
        throw this.error(institutionalPage.getId(), institutionalPage);
    }

    public InstitutionalPageEntity approve(UUID institutionalPageId, InstitutionalPageEntity institutionalPage) {
        if (institutionalPage.getModerationStatus().equals((Object)ModerationStatus.PENDING)) {
            InstitutionalPageEntity approvedInstitutionalPage;
            if (institutionalPage.getOriginalInstitutionalPageId() != null) {
                approvedInstitutionalPage = this.institutionalPageHelper.retrieveOriginalInstitutionalPage(institutionalPage);
                this.entityBuilder.updateEntity(approvedInstitutionalPage, institutionalPage);
                approvedInstitutionalPage.setUpdatedInstitutionalPageId(null);
                this.institutionalPageHelper.delete(institutionalPage);
            } else {
                approvedInstitutionalPage = institutionalPage;
            }
            if (approvedInstitutionalPage.getPublicationTime() == null && approvedInstitutionalPage.isPublished()) {
                approvedInstitutionalPage.setPublicationTime(Instant.now());
            }
            approvedInstitutionalPage.setModerationStatus(ModerationStatus.APPROVED);
            approvedInstitutionalPage.setRejectionMessage("");
            return approvedInstitutionalPage;
        }
        throw this.error(institutionalPageId, institutionalPage);
    }

    public InstitutionalPageEntity reject(UUID institutionalPageId, InstitutionalPageEntity institutionalPage, String message) {
        if (institutionalPage.getModerationStatus().equals((Object)ModerationStatus.PENDING)) {
            institutionalPage.setModerationStatus(ModerationStatus.REJECTED);
            institutionalPage.setRejectionMessage(message);
            return institutionalPage;
        }
        throw this.error(institutionalPageId, institutionalPage);
    }

    public InstitutionalPageEntity update(UUID userId, UUID institutionalPageId, InstitutionalPageEntity institutionalPage) {
        if (institutionalPage.getModerationStatus().equals((Object)ModerationStatus.PENDING)) {
            throw this.error(institutionalPageId, institutionalPage);
        }
        if (institutionalPage.getModerationStatus().equals((Object)ModerationStatus.REJECTED)) {
            institutionalPage.setModerationStatus(ModerationStatus.PENDING);
            return institutionalPage;
        }
        if (institutionalPage.getModerationStatus().equals((Object)ModerationStatus.APPROVED)) {
            InstitutionalPageEntity clonedInstitutionalPage = this.entityBuilder.cloneInstitutionalPageEntity(institutionalPage);
            clonedInstitutionalPage.setOriginalInstitutionalPageId(institutionalPage.getId());
            clonedInstitutionalPage.setModerationStatus(ModerationStatus.PENDING);
            InstitutionalPageEntity savedClonedInstitutionalPage = this.institutionalPageHelper.save(userId, clonedInstitutionalPage);
            institutionalPage.setUpdatedInstitutionalPageId(savedClonedInstitutionalPage.getId());
            this.institutionalPageHelper.save(userId, institutionalPage);
            return savedClonedInstitutionalPage;
        }
        throw new UnexpectedModerationStatusException(institutionalPage.getId(), institutionalPage.getModerationStatus());
    }

    public InstitutionalPageEntity prepareForImmediateDeletion(InstitutionalPageEntity institutionalPage) {
        InstitutionalPageEntity originalInstitutionalPage;
        if (institutionalPage.getOriginalInstitutionalPageId() != null) {
            originalInstitutionalPage = this.institutionalPageHelper.retrieveOriginalInstitutionalPage(institutionalPage);
            this.institutionalPageHelper.delete(institutionalPage);
        } else {
            originalInstitutionalPage = institutionalPage;
        }
        return originalInstitutionalPage;
    }

    private InvalidModerationStatusException error(UUID institutionalPageId, InstitutionalPageEntity institutionalPageEntity) {
        return new InvalidModerationStatusException(institutionalPageId, institutionalPageEntity.getModerationStatus());
    }

    @Generated
    public InstitutionalPageModerationHandler(InstitutionalPageHelper institutionalPageHelper, EntityBuilder entityBuilder) {
        this.institutionalPageHelper = institutionalPageHelper;
        this.entityBuilder = entityBuilder;
    }
}

